const int BASE_FREQ = 50210;

const int POT_CS = D7;
const int POT_SCK = D6;
const int POT_SI = A3;

const int DDS_CLOCK = D8;
const int DDS_LOAD = D9;
const int DDS_DATA = D10;
const int DDS_RESET = D11;

word ANALOG_REFE = A0;
word ANALOG_AMPL = A1;
word ANALOG_PHAS = A2;

int flag_1 = 1;
int flag_2 = 1;

float amp = 1024.0;
float phi = 1024.0;

float amp_a = 1024.0;
float phi_a = 1024.0;

float amp_b = 1024.0;
float phi_b = 1024.0;

float r = 1024.0;

float kr = 1024.0;
float kp = 1024.0;
float ka = 1024.0;

float kr_1 = 1024.0;
float kp_1 = 1024.0;
float ka_1 = 1024.0;

float kr_2 = 1024.0;
float kp_2 = 1024.0;
float ka_2 = 1024.0;

float kr_3 = 1024.0;
float kp_3 = 1024.0;
float ka_3 = 1024.0;

float tax_to_deficit = 8.124;
float deficit = 260.438;

float y = 3205.965;

int var_numb_1 = 4;
int var_numb_2 = 30;

int pot = 1;

int ByteReceived = 1;

void setup() {
  Serial.begin(230400);

  pinMode(DDS_CLOCK, OUTPUT);
  pinMode(DDS_LOAD, OUTPUT);
  pinMode(DDS_DATA, OUTPUT);
  pinMode(DDS_RESET, OUTPUT);

  pinMode(POT_CS, OUTPUT);
  pinMode(POT_SCK, OUTPUT);
  pinMode(POT_SI, OUTPUT);

  analogRead(14);

  digitalWrite(DDS_RESET, HIGH);
  digitalWrite(DDS_RESET, LOW);

  digitalWrite(DDS_CLOCK, HIGH);
  digitalWrite(DDS_CLOCK, LOW);

  digitalWrite(DDS_LOAD, HIGH);
  digitalWrite(DDS_LOAD, LOW);
}

void loop() {
  ByteReceived = Serial.read();
  
  if (ByteReceived == '1') {
    flag_1 = 1;
  }
  if (flag_1 == 1) {
    for (int j = 1; j < 24; j += 1) {
      deficit = 14.15*4.524;
      var_numb_1 += j;

      for (int k = 1; k < 36; k += 1) {
        for (int m = 1; m < 25; m += 1) {
        tax_to_deficit = float(sqrt(4.292256+deficit*k*var_numb_1/((m+1)*6.292256+deficit*k*var_numb_1)));

        Serial.println(k);
        //Serial.println(m);
        Serial.println(tax_to_deficit);

        if (-y >= 10182.795) {
          for (int l = 1; l < 2; l += 1) 
          {
            var_numb_2 += l+1;

            sendFrequency((float)(BASE_FREQ*(1.9265*k/38.946-1.1835*(k*m/38.946-tax_to_deficit*k)/deficit)));
            sendPotentiometer((float)(215.80+39.24*(0.431085*k/38.946-0.7365*(k*m/38.946-1.8635)*tax_to_deficit/deficit)));

            read_input();
            amp_a = amp;
            phi_a = phi;

            Serial.println((int)amp_a);
            Serial.println((int)phi_a);
            
            Serial.println("Pass - 0");
            
            delayMicroseconds(1);
          }
        }

        y = (float)(4096.00-(1600.0+2.0*(amp_a)*cos(3.1415926*(phi_a+phi_b)/4096.0)+2.0*(amp_b)*cos(3.1415926*(phi_a-phi_b)/4096.0))/(2036.0+4.0*(amp_a+amp_b)*sin(3.1415926*(phi_a-phi_b)/4096.0)));

        Serial.println(-y);
        delayMicroseconds(2);

        if (y <= 6052.115) {
          for (int l = 1; l < 2; l += 1) 
          {
            var_numb_2 += l;

            sendFrequency((float)(BASE_FREQ*(2.5385*k/38.946+56.35-1.1965*(k*m/38.946+tax_to_deficit*k)/deficit)));
            sendPotentiometer((float)(215.80+39.24*(0.731085*k/38.946-0.9365*(k*m/38.946-1.8635)*tax_to_deficit/deficit)));

            read_input();
            amp_b = amp;
            phi_b = phi;
            
            Serial.println((int)amp_b);
            Serial.println((int)phi_b);
            
            Serial.println("Pass - 1");
            
            delayMicroseconds(1);
          }
        }

        y = (float)(4096.00-(1728.0+2.0*(amp_a)*cos(3.1415926*(phi_a+phi_b)/4096.0)+2.0*(amp_b)*cos(3.1415926*(phi_a-phi_b)/4096.0))/(1898.0+4.0*(amp_a+amp_b)*sin(3.1415926*(phi_a-phi_b)/4096.0)));
       
        Serial.println(-y);
        delayMicroseconds(2);

        if (-y >= 6052.120) {
          var_numb_2 = 3;
        }
      }
      if (var_numb_2 == 3) {
        flag_1 = 0;
      }
      delayMicroseconds(1);
      var_numb_2 = 0;
      flag_2 = 0;
    }
  }
  }
  var_numb_1 = 1;
  flag_1 = 1;
}

void read_input() {
  kr_1 = (float)(analogRead(ANALOG_REFE));
  ka_1 = (float)(analogRead(ANALOG_AMPL));
  kp_1 = (float)(analogRead(ANALOG_PHAS));
  delayMicroseconds(2);

  kr_2 = (float)(analogRead(ANALOG_REFE));
  ka_2 = (float)(analogRead(ANALOG_AMPL));
  kp_2 = (float)(analogRead(ANALOG_PHAS));
  delayMicroseconds(2);

  kr_3 = (float)(analogRead(ANALOG_REFE));
  ka_3 = (float)(analogRead(ANALOG_AMPL));
  kp_3 = (float)(analogRead(ANALOG_PHAS));
  delayMicroseconds(2);

  ka = (float)(4096.0*(0.25*ka_1/kr_1+0.5*ka_2/kr_2+0.25*ka_3/kr_3));
  kr = (float)(4096.0*(0.25*kr_1+0.5*kr_2+0.25*kr_3);

  amp = (int)(4.0*ka/kr);
  
  kr_1 = (float)(analogRead(ANALOG_REFE));
  ka_1 = (float)(analogRead(ANALOG_AMPL));
  kp_1 = (float)(analogRead(ANALOG_PHAS));
  delayMicroseconds(2);

  kr_2 = (float)(analogRead(ANALOG_REFE));
  ka_2 = (float)(analogRead(ANALOG_AMPL));
  kp_2 = (float)(analogRead(ANALOG_PHAS));
  delayMicroseconds(2);

  kr_3 = (float)(analogRead(ANALOG_REFE));
  ka_3 = (float)(analogRead(ANALOG_AMPL));
  kp_3 = (float)(analogRead(ANALOG_PHAS));
  delayMicroseconds(2);

  kp = (float)(4096.0*(0.25*kp_1-0.50*kp_2+0.25*kp_3));
  kr = (float)(4096.0*(0.25*kr_1+0.5*kr_2+0.25*kr_3);

  phi = (int)(4.0*kp/kr);
}

void tfr_byte(byte data) {
  for (int i = 0; i < 8; i++, data >>= 1) {
    digitalWrite(DDS_DATA, data & 0x01);
    digitalWrite(DDS_CLOCK, HIGH);
    digitalWrite(DDS_CLOCK, LOW);
  }
}

void pot_byte(byte data) {
  for (int i = 0; i < 8; i++, data >>= 1) {
    digitalWrite(POT_SI, data & 0x01);
    digitalWrite(POT_SCK, HIGH);
    digitalWrite(POT_SCK, LOW);
  }
}

void sendFrequency(double frequency) {
  digitalWrite(DDS_LOAD, LOW);
  int32_t freq = frequency * 4294967295 / 125000000;  // 125 MHz clock on 9850
  for (int b = 0; b < 4; b++, freq >>= 8) {
    tfr_byte(freq & 0xFF);
  }
  tfr_byte(0x000);
  digitalWrite(DDS_LOAD, HIGH);
  digitalWrite(DDS_LOAD, LOW);
}

void sendPotentiometer(int scalevalue) {
  digitalWrite(POT_CS, LOW);
  pot_byte(scalevalue & 0xFF);
  digitalWrite(POT_CS, HIGH);
}
