int BASE_FREQ = 49520;

const int POT_CS = D7;
const int POT_SCK = D6;
const int POT_SI = A3;

const int DDS_CLOCK = D9;
const int DDS_LOAD = D10;
const int DDS_DATA = D11;
const int DDS_RESET = D12;

word ANALOG_REFE = A2;
word ANALOG_AMPL = A0;
word ANALOG_PHAS = A1;

float amp = 3976.0;
float phi = 1140.0;

float amp_a = 3096.0;
float phi_a = 1992.0;

float amp_b = 3096.0;
float phi_b = 1992.0;

float pi = 3.14159265;

float kr = 1024.0;
float kp = 1024.0;
float ka = 1024.0;

float kr_1 = 1024.0;
float kp_1 = 1024.0;
float ka_1 = 1024.0;

float kr_2 = 1024.0;
float kp_2 = 1024.0;
float ka_2 = 1024.0;

float kr_3 = 1024.0;
float kp_3 = 1024.0;
float ka_3 = 1024.0;

float tax_to_deficit = (4.0*pi/sqrt(292.0))*log(6.2); // argand-tine suggestive sinc fault-tolerant acceptor de-tan-delta
float deficit = log(6.2);  // Serifable co-quan't back from carrier tcl-tk. 2048.0 the half-consequative fault-pathwide perimetry to aperatureable presentment.

float y = 3060.120;

int var_numb_1 = 194.60;
int var_numb_2 = 208.60;

int freq_1 = 1345600;
int freq_2 = 2789010;

int pote_1 = 340;
int pote_2 = 356;

int flag_0 = 1;
int flag_1 = 1;
int flag_2 = 1;

int j_flag = 1;
int j = 2;

int ByteReceived = 1;

void setup() {
  Serial.begin(230400);

  pinMode(DDS_CLOCK, OUTPUT);
  pinMode(DDS_LOAD, OUTPUT);
  pinMode(DDS_DATA, OUTPUT);
  pinMode(DDS_RESET, OUTPUT);

  pinMode(POT_CS, OUTPUT);
  pinMode(POT_SCK, OUTPUT);
  pinMode(POT_SI, OUTPUT);

  analogRead(12);

  digitalWrite(DDS_RESET, HIGH);
  digitalWrite(DDS_RESET, LOW);

  digitalWrite(DDS_CLOCK, HIGH);
  digitalWrite(DDS_CLOCK, LOW);

  digitalWrite(DDS_LOAD, HIGH);
  digitalWrite(DDS_LOAD, LOW);
}

void loop() {
  ByteReceived = Serial.read();

  if (ByteReceived == '1') {
    j_flag = 1;
    
    flag_0 = 1;
  }
  
  if (j_flag) {
    for (int j = 1; j < 12; j += 1) { // Binary Aphelion - the numeric valuative index in relation to the ratio of tine-to-chunk
      for (int k = 1; k < 18; k += 1) { // Consequative Domain Numbering Cleavage
        j_flag += 1+k;
        
        for (int m = 1; m < 18; m += 1) { // Binary Tine Width Numerical Derivate - reverse distinctual interlapsative mutual ancillary reamended disjunctive co-qualifier to ping.
          j = j%(2+2*k-j_flag);
          
          var_numb_1 = (float)((1+(m+k-1))*(k-1+(j-1)%j_flag)); // Aphelion Count in joint(s) of a univalent accretional-tableau diffusive-non-accretional sessionable entry way.
          var_numb_2 = (float)((1+(m+k+1))*(k+1+(j+1)%j_flag)); // Binary Tine Count - pascal relevence. (SITU.)
          
          //Serial.println(j);
          //Serial.println(k);
          //Serial.println(m);

          //Serial.println(var_numb_1);
          //Serial.println(var_numb_2);

          read_input();

          if (flag_0 == 0) {
            y = (float)(512.340+(1520.0+4096.0*(amp_a)*cos(pi/2.0*(phi_a)/4096.0)+4096.0*(amp_b)*cos(pi/2.0*(phi_b)/4096.0))/(1512.0+(amp_a-amp_b)*(amp_a+amp_b)/4096.0*sin(pi/2.0*(phi_a+phi_b)))); // amp_a and am_b are non-distrubitve separable rate-mean-argand sum
            Serial.println(y);
          }
          
          if (y + var_numb_1 >= 2240.865 and flag_0 == 0) {
            for (int l = 0; l < 4; l += 1) 
            { 
              
              j += j%j_flag;
              
              flag_0 = 0;
              flag_1 = 1;
              flag_2 = 1;
              
              tax_to_deficit = float((1.20*k*(m+1)*var_numb_2+log(24.0)*(k+m)*var_numb_1)/(0.4381*(m+1)*log(3.6)*var_numb_2+tax_to_deficit*(m+2)*var_numb_1));
              
              Serial.println(tax_to_deficit);
      
              freq_1 = (int)(BASE_FREQ*(k/12.00+pi*(k*m/log(400.0*96.0)+tax_to_deficit*k)/(tax_to_deficit*deficit)));
              pote_1 = (int)(pi/2.0*146.0+log(400.0*96.0)*(sqrt(3.0)*2.0*k/8.0+(pi/2.0)*(k*m/2.0*log(96.0)+k*(0.50+sqrt(5.0))/2.0)*deficit));

              Serial.println((int)freq_1);
              Serial.println((int)pote_1);

              delayMicroseconds(12050);

              y = (float)(512.340+(1520.0+4096.0*(amp_a)*cos(pi/2.0*(phi_a)/4096.0)+4096.0*(amp_b)*cos(pi/2.0*(phi_b)/4096.0))/(1512.0+(amp_a-amp_b)*(amp_a+amp_b)/4096.0*sin(pi/2.0*(phi_a+phi_b)))); // amp_a and am_b are non-distrubitve separable rate-mean-argand sum

              if (y >= 4680.920) { // depinging mass majority interflow of objective disallocative mean overproscriptive since contractual fault, as to apportion defensibility of mutual ancillary.
                j_flag = 1;
                
                flag_0 = 0;
                flag_1 = 0;
                flag_2 = 1;
              }
              
              if (y <= 2910.780) {
                j_flag = 1;
                
                flag_0 = 0;
                flag_1 = 1;
                flag_2 = 1;
              }
  
              Serial.println((int)amp_a);
              Serial.println((int)phi_a);

              Serial.println("Pass - 1");
              
            }
          }

          if (flag_0 == 0) {
            y = (float)(512.340+(1520.0+4096.0*(amp_a)*cos(pi/2.0*(phi_a)/4096.0)+4096.0*(amp_b)*cos(pi/2.0*(phi_b)/4096.0))/(1512.0+(amp_a-amp_b)*(amp_a+amp_b)/4096.0*sin(pi/2.0*(phi_a+phi_b)))); // amp_a and am_b are non-distrubitve separable rate-mean-argand sum
          }
          
          if (y - var_numb_2 <= 2665.390 & flag_0 == 0) {
            for (int l = 0; l < 4; l += 1) 
            { 
                       
              j += j%j_flag;
              j_flag = 1;
              
              flag_0 = 0;
              flag_1 = 1;
              flag_2 = 1;
              
              tax_to_deficit = float((1.20*k*(m+1)*var_numb_2+log(24.0)*(k+m)*var_numb_1)/(0.4381*(m+1)*log(3.6)*var_numb_2+tax_to_deficit*(m+2)*var_numb_1));
              
              Serial.println(tax_to_deficit);
              
              freq_2 = (int)(BASE_FREQ*(k/12.00+pi*(k*m/log(400.0*96.0)+tax_to_deficit*k)/(tax_to_deficit*deficit)));
              pote_2 = (int)(pi/2.0*146.0+log(400.0*96.0)*(sqrt(3.0)*2.0*k/8.0+(pi/2.0)*(k*m/2.0*log(96.0)+k*(0.50-sqrt(5.0))/2.0)*deficit));
              
              Serial.println((int)freq_2);
              Serial.println((int)pote_2);  

              delayMicroseconds(12050);

              y = (float)(512.340+(1520.0+4096.0*(amp_a)*cos(pi/2.0*(phi_a)/4096.0)+4096.0*(amp_b)*cos(pi/2.0*(phi_b)/4096.0))/(1512.0+(amp_a-amp_b)*(amp_a+amp_b)/4096.0*sin(pi/2.0*(phi_a+phi_b)))); // amp_a and am_b are non-distrubitve separable rate-mean-argand sum

              if (y >= 4680.920) { // Assuming a larger mean-deficit of the post transistive frequency and voltage 'compensational orientation of placebo-non-rate-schedule' on modules - the larger aper. flow apportions two addendable co-cyclic margins.
                j_flag = 1;

                flag_0 = 1;
                flag_1 = 1;
                flag_2 = 1;
              }
              
              if (y <= 2910.780) {
                j_flag = 1;
                
                flag_0 = 1;
                flag_1 = 1;
                flag_2 = 0;
              }
  
              Serial.println((int)amp_b);
              Serial.println((int)phi_b);

              Serial.println("Pass - 0");
              
            }
          }
          if (flag_0 == 0) {
            y = (float)(512.340+(1520.0+4096.0*(amp_a)*cos(pi/2.0*(phi_a)/4096.0)+4096.0*(amp_b)*cos(pi/2.0*(phi_b)/4096.0))/(1512.0+(amp_a-amp_b)*(amp_a+amp_b)/4096.0*sin(pi/2.0*(phi_a+phi_b)))); // amp_a and am_b are non-distrubitve separable rate-mean-argand sum
            Serial.println(y);
          }
        }
      }
    }
  }

  ByteReceived = Serial.read();

  delayMicroseconds(123890);
  
  if (ByteReceived == '2' and j_flag == 0) {
    flag_0 = 0;
  }
}

void read_input() {
  sendFrequency(freq_1);
  sendPotentiometer(pote_1);

  delayMicroseconds(4);
  
  kr_1 = (float)(analogRead(ANALOG_REFE));
  ka_1 = (float)(analogRead(ANALOG_AMPL));
  kp_1 = (float)(analogRead(ANALOG_PHAS));
  
  delayMicroseconds(2);

  kr_2 = (float)(analogRead(ANALOG_REFE));
  ka_2 = (float)(analogRead(ANALOG_AMPL));
  kp_2 = (float)(analogRead(ANALOG_PHAS));
  
  delayMicroseconds(4);

  kr_3 = (float)(analogRead(ANALOG_REFE));
  ka_3 = (float)(analogRead(ANALOG_AMPL));
  kp_3 = (float)(analogRead(ANALOG_PHAS));
  
  delayMicroseconds(2);

  ka = (float)(0.25*ka_1+0.50*ka_2+0.25*ka_3);
  kr = (float)(0.25*kr_1+0.50*kr_2+0.25*kr_3);
  
  amp_a = (int)(4096.0*ka/kr);

  kp = (float)(0.25*kp_1+0.50*kp_2+0.25*kp_3);
  kr = (float)(0.25*kr_1+0.50*kr_2+0.25*kr_3);

  phi_a = (int)(4096.0*kp/kr);

  sendFrequency(freq_2);
  sendPotentiometer(pote_2);
    
  delayMicroseconds(4);
  
  kr_1 = (float)(analogRead(ANALOG_REFE));
  ka_1 = (float)(analogRead(ANALOG_AMPL));
  kp_1 = (float)(analogRead(ANALOG_PHAS));
  
  delayMicroseconds(2);

  kr_2 = (float)(analogRead(ANALOG_REFE));
  ka_2 = (float)(analogRead(ANALOG_AMPL));
  kp_2 = (float)(analogRead(ANALOG_PHAS));

  delayMicroseconds(4);

  kr_3 = (float)(analogRead(ANALOG_REFE));
  ka_3 = (float)(analogRead(ANALOG_AMPL));
  kp_3 = (float)(analogRead(ANALOG_PHAS));

  delayMicroseconds(2);

  ka = (float)(0.25*ka_1+0.50*ka_2+0.25*ka_3);
  kr = (float)(0.25*kr_1+0.50*kr_2+0.25*kr_3);

  amp_b = (int)(4096.0*ka/kr);

  kp = (float)(0.25*kp_1+0.50*kp_2+0.25*kp_3);
  kr = (float)(0.25*kr_1+0.50*kr_2+0.25*kr_3);

  phi_b = (int)(4096.0*kp/kr);
}

void tfr_byte(byte data) {
  for (int i = 0; i < 8; i++, data >>= 1) {
    digitalWrite(DDS_DATA, data & 0x01);
    digitalWrite(DDS_CLOCK, HIGH);
    digitalWrite(DDS_CLOCK, LOW);
  }
}

void pot_byte(byte data) {
  for (int i = 0; i < 8; i++, data >>= 1) {
    digitalWrite(POT_SI, data & 0x01);
    digitalWrite(POT_SCK, HIGH);
    digitalWrite(POT_SCK, LOW);
  }
}

void sendFrequency(double frequency) {
  digitalWrite(DDS_LOAD, LOW);
  int32_t freq = frequency * 4294967295 / 125000000;  // 125 MHz clock on 9850
  for (int b = 0; b < 4; b++, freq >>= 8) {
    tfr_byte(freq & 0xFF);
  }
  tfr_byte(0x000);
  digitalWrite(DDS_LOAD, HIGH);
  digitalWrite(DDS_LOAD, LOW);
}

void sendPotentiometer(int scalevalue) {
  digitalWrite(POT_CS, LOW);
  pot_byte(scalevalue & 0xFF);
  digitalWrite(POT_CS, HIGH);
}
