float BASE_FREQ = 1651380;

const int POT_CS = 10;
const int POT_SCK = 11;
const int POT_SI = A2;

const int DDS_CLOCK = 13;
const int DDS_LOAD = A3;
const int DDS_DATA = 12;

word ANALOG_AMPL = A0;
word ANALOG_PHAS = A1;

float amp = 3976.0;
float phi = 1140.0;

float amp_a = 3096.0;
float phi_a = 1992.0;

float amp_b = 3096.0;
float phi_b = 1992.0;

float pi = 3.14159265358979323846264338;

float kr = 1024.0;
float kp = 1024.0;
float ka = 1024.0;

float kr_1 = 1024.0;
float kp_1 = 1024.0;
float ka_1 = 1024.0;

float kr_2 = 1024.0;
float kp_2 = 1024.0;
float ka_2 = 1024.0;

float kr_3 = 1024.0;
float kp_3 = 1024.0;
float ka_3 = 1024.0;

float tax_to_deficit = 5.32020*log((2.0*pi)/4096.20);
float deficit = 2.34980*log(4096.40/(2.0*pi));

float y = 782.850;
float yd = 1781.260;

float beta = 2.4;

int var_numb_1 = 1.7102590;
int var_numb_2 = 2.9078510;

int freq_1 = 138950;
int freq_2 = 845640;

int pote_1 = 1230;
int pote_2 = 1340;

int flag_0 = 0;
int flag_1 = 1;
int flag_2 = 0;

int j_flag = 1;
int flag_goal_previous = 0;

int addend = 796;
int ded = 1;
int j = 1;

int ByteReceived = 0;
int nulled = 1;

byte nosaid_buffer = 1;

String instruction_base = "";

int j_lim = 0;
int k_lim = 0;
int m_lim = 0;

void setup() {
  Serial.begin(921600);

  pinMode(DDS_CLOCK, OUTPUT);
  pinMode(DDS_LOAD, OUTPUT);
  pinMode(DDS_DATA, OUTPUT);

  pinMode(POT_CS, OUTPUT);
  pinMode(POT_SCK, OUTPUT);
  pinMode(POT_SI, OUTPUT);

  analogRead(12);

  digitalWrite(DDS_CLOCK, HIGH);
  digitalWrite(DDS_CLOCK, LOW);

  digitalWrite(DDS_LOAD, HIGH);
  digitalWrite(DDS_LOAD, LOW);
}

void loop() {
  delayMicroseconds(2);
  
  ByteReceived = Serial.read();

  if (ByteReceived == '1') {
    flag_0 = 1;
    flag_goal_previous = 1;
    nulled = 1;
  }

  if (addend <= j and flag_0 and flag_goal_previous and nulled == '0') {
    nulled = 1;
  } else {
    nulled = 0;
  }

  if (flag_0 and flag_goal_previous) {
    j_lim = Serial.parseInt();
    k_lim = Serial.parseInt();
    m_lim = Serial.parseInt();
    
    instruction_base = Serial.readString();
    instruction_base.trim();

    byte nosaid_buffer[(int)instruction_base.length()+1];
          
    for (int l = 0; l < (int)sizeof(nosaid_buffer); l++) {
      j += (int)(j_flag+j_lim%2+k_lim%2+m_lim%2)%((int)nosaid_buffer[l]);

      for (int o = 0; o <= j_lim; o += 1) { 
        for (int k = 0; k <= k_lim; k += 1) {       
          for (int m = 0; m <= m_lim; m += 1) {
              instruction_base.getBytes(nosaid_buffer, sizeof(nosaid_buffer));

              j_flag += (j+j_flag+1)%2-flag_1+flag_2;
              
              delayMicroseconds(2);

              if (flag_0) {
                j += 1;
                j_flag += -j%2-flag_1+flag_2;
              }
      
              ded += -((1+addend-j%2)%(1+j-ded))%2;
              j += (ded-addend)%2;

              tax_to_deficit = float((-(192.0/18.0)*(j+k)*m*var_numb_1*tax_to_deficit+(192.0/18.0)*(j+m)*k*var_numb_2)/(m*log(192.0/120.0)*var_numb_1*tax_to_deficit*+(k+m)*var_numb_2*deficit)/4096.0);
    
              var_numb_1 = (float)((k*(k-1))*((k+1)%(addend-j)))/(log(119.0));
              var_numb_2 = (float)((k*(k+1))*((k-1)%(addend+j)))/(log(126.0));

              principles(j, k, m, var_numb_1, var_numb_2, tax_to_deficit);

              y = (float)((4096.0+(amp_a)*cos(pi*(phi_a-phi_b)/4096.0)+(amp_b)*cos(pi*(phi_a-phi_b)/4096.0))/(4096.0-(amp_a-amp_b)*(amp_a+amp_b)/2048.0*sin(2.0*pi*(phi_a+phi_b)/4096.0)*cos(2.0*pi*(phi_a+phi_b)/4096.0)));
              yd = (float)((int)(m*var_numb_1/k*var_numb_2)%(j_flag+j-1))/4096.0-(float)((int)(k*var_numb_1/m*var_numb_2)%(j_flag+j+1))/4096.0;

              beta = (float)(4096.0*yd-var_numb_1*y+var_numb_2*y*yd);

              if (y >= 4096.0+beta) {
                for (int l = 0; l <= 2; l += 1) 
                { 
                  j_flag += (j+j_flag+1)%2-flag_1+flag_2;
                  
                  if (flag_0) {
                    j += 1;
                    j_flag += -j%2-flag_1+flag_2;
                  }

                  y = (float)((4096.0+(amp_a)*cos(pi*(phi_a-phi_b)/4096.0)+(amp_b)*cos(pi*(phi_a-phi_b)/4096.0))/(4096.0-(amp_a-amp_b)*(amp_a+amp_b)/2048.0*sin(2.0*pi*(phi_a+phi_b)/4096.0)*cos(2.0*pi*(phi_a+phi_b)/4096.0)));
                  yd = (float)((int)(m*var_numb_1/k*var_numb_2)%(j_flag+j-1))/4096.0-(float)((int)(k*var_numb_1/m*var_numb_2)%(j_flag+j+1))/4096.0;

                  beta = (float)(4096.0*yd-var_numb_1*y+var_numb_2*y*yd);
          
                  if (y >= 4230.6+beta) {
                    flag_1 = 1;
                    flag_2 = 0;
    
                    k += 1+(j-m*flag_1+k*flag_2)%2;
                    m += 1+(-j+m*flag_1+k*flag_2)%2;
                    
                    if ((j_flag+flag_1+flag_2)%2 and addend >= j) {
                      Serial.println("t = -0.10 mark");
                      
                      flag_goal_previous = 1;
                      j += j_flag%2+(flag_1+flag_2)%2;           
                    }
                  }
                  
                  j_flag += (j+j_flag+1)%2-flag_1+flag_2;
                  
                  if (flag_0) {
                    j += 1;
                    j_flag += -j%2-flag_1+flag_2;
                  }
          
                  if (y <= 4096.0-beta) {
                    flag_1 = 1;
                    flag_2 = 1;
    
                    k += 1+(j-m*flag_1+k*flag_2)%2;
                    m += 1+(-j+m*flag_1+k*flag_2)%2;
                      
                    if ((j_flag+flag_1+flag_2)%2 and addend >= j) {
                      Serial.println("t = -0.11 mark");
                   
                      flag_goal_previous = 1;
                      j += j_flag%2-(flag_1+flag_2)%2;            
                    }
                  }
                  
                  delayMicroseconds(1);
                }
              }
    
              delayMicroseconds(2);

              if (flag_0) {
                j += 1;
                j_flag += -j%2-flag_1+flag_2;
              }
      
              ded += -((1+addend-j%2)%(1+j_flag-ded))%2;
              j += (ded-addend)%2;

              tax_to_deficit = float((-(192.0/18.0)*(j+k)*m*var_numb_1*tax_to_deficit+(192.0/18.0)*(j+m)*k*var_numb_2)/(m*log(192.0/120.0)*var_numb_1*tax_to_deficit*+(k+m)*var_numb_2*deficit)/4096.0);
    
              var_numb_1 = (float)((k*(k-1))*((k+1)%(addend-j)))/(log(119.0));
              var_numb_2 = (float)((k*(1+k))*((k-1)%(addend+j)))/(log(126.0));

              principles(j, k, m, var_numb_1, var_numb_2, tax_to_deficit);
              
              y = (float)((4096.0+(amp_a)*cos(pi*(phi_a-phi_b)/4096.0)+(amp_b)*cos(pi*(phi_a-phi_b)/4096.0))/(4096.0-(amp_a-amp_b)*(amp_a+amp_b)/2048.0*sin(2.0*pi*(phi_a+phi_b)/4096.0)*cos(2.0*pi*(phi_a+phi_b)/4096.0)));
              yd = (float)((int)(m*var_numb_1/k*var_numb_2)%(j_flag+j-1))/4096.0-(float)((int)(k*var_numb_1/m*var_numb_2)%(j_flag+j+1))/4096.0;

              beta = (float)(4096.0*yd-var_numb_1*y+var_numb_2*y*yd);

              if (y <= 3876.4) {
                for (int l = 0; l < 2; l += 1) 
                {  
                  j_flag += (j+j_flag+1)%2-flag_1+flag_2;
                  
                  if (flag_0) {
                    j += 1;
                    j_flag += -j%2+flag_1+flag_2;
                  }

                  y = (float)((4096.0+(amp_a)*cos(pi*(phi_a-phi_b)/4096.0)+(amp_b)*cos(pi*(phi_a-phi_b)/4096.0))/(4096.0-(amp_a-amp_b)*(amp_a+amp_b)/2048.0*sin(2.0*pi*(phi_a+phi_b)/4096.0)*cos(2.0*pi*(phi_a+phi_b)/4096.0)));
                  yd = (float)((int)(m*var_numb_1/k*var_numb_2)%(j_flag+j-1))/4096.0-(float)((int)(k*var_numb_1/m*var_numb_2)%(j_flag+j+1))/4096.0;

                  beta = (float)(4096.0*yd-var_numb_1*y+var_numb_2*y*yd);
          
                  if (y >= 4106+beta) {
                    flag_1 = 0;
                    flag_2 = 1;
    
                    k += 1+(j-m*flag_1+k*flag_2)%2;
                    m += 1+(-j+m*flag_1+k*flag_2)%2;
    
                    if ((j_flag+flag_1+flag_2)%2 and addend >= j) {
                      Serial.println("t = -0.01 mark");
    
                      flag_goal_previous = 1;
                      j += j_flag%2-(flag_1+flag_2)%2;         
                    }
                  }

                  j_flag += (j+j_flag+1)%2-flag_1+flag_2;
                  
                  if (flag_0) {
                    j += 1;
                    j_flag += -j%2-flag_1+flag_2;
                  }

                  y = (float)((4096.0+(amp_a)*cos(pi*(phi_a-phi_b)/4096.0)+(amp_b)*cos(pi*(phi_a-phi_b)/4096.0))/(4096.0-(amp_a-amp_b)*(amp_a+amp_b)/2048.0*sin(2.0*pi*(phi_a+phi_b)/4096.0)*cos(2.0*pi*(phi_a+phi_b)/4096.0)));
                  yd = (float)((int)(m*var_numb_1/k*var_numb_2)%(j_flag+j-1))/4096.0-(float)((int)(k*var_numb_1/m*var_numb_2)%(j_flag+j+1))/4096.0;

                  beta = (float)(4096.0*yd-var_numb_1*y+var_numb_2*y*yd);
          
                  if (y <= 3782.0-beta) {
                    flag_1 = 0;
                    flag_2 = 0;
    
                    k += 1+(j-m*flag_1+k*flag_2)%2;
                    m += 1+(-j+m*flag_1+k*flag_2)%2;
                    
                    if ((j_flag+flag_1+flag_2)%2 and addend >= j) {
                      Serial.println("t = -0.00 mark");
                                        
                      flag_goal_previous = 1;
                      j += j_flag%2+(flag_1+flag_2)%2;         
                    }
                  }
                  delayMicroseconds(1);
                }
              }
            }
          }
        }
      }
      
    if (nulled or addend <= j) {
      flag_0 = 1;
      flag_goal_previous = 1;
      nulled = 1;
    } else {
      flag_0 = 1;
      flag_goal_previous = 1;
      nulled = 0;
    }
  }
  
  j += j_flag%j-1;
  j_flag += j_flag%2;

  ByteReceived = Serial.read();

  if (ByteReceived == '1') {
    flag_0 = 1;
    flag_goal_previous = 1;
    Serial.println("Closed Channel.");    
    nulled = 0;
  }
  
  if (ByteReceived == '2' and (addend+ded+j)%2) {
    flag_0 = 1;
    flag_goal_previous = 0;
    nulled = 1;
    addend += 1-(ded+j)%2+(2*j+addend)%2;
  } else {
    ded += -((1+ded-j%2)%(2-j+addend))%2;
    j += (ded-addend)%2;
  }
}

void read_input() {
  sendFrequency(freq_1);
  sendPotentiometer(pote_1);

  delayMicroseconds(1);
  
  ka_1 = (float)(analogRead(ANALOG_AMPL));
  kp_1 = (float)(analogRead(ANALOG_PHAS));
  
  ka_2 = (float)(analogRead(ANALOG_AMPL));
  kp_2 = (float)(analogRead(ANALOG_PHAS));

  ka_3 = (float)(analogRead(ANALOG_AMPL));
  kp_3 = (float)(analogRead(ANALOG_PHAS));
  
  delayMicroseconds(1);

  ka = (float)(0.25*ka_1+0.50*ka_2+0.25*ka_3);
  
  amp_a = (int)(ka);

  kp = (float)(0.25*kp_1+0.50*kp_2+0.25*kp_3);

  phi_a = (int)(kp);

  sendFrequency(freq_2);
  sendPotentiometer(pote_2);
    
  delayMicroseconds(1);
  
  ka_1 = (float)(analogRead(ANALOG_AMPL));
  kp_1 = (float)(analogRead(ANALOG_PHAS));
  
  ka_2 = (float)(analogRead(ANALOG_AMPL));
  kp_2 = (float)(analogRead(ANALOG_PHAS));
  
  ka_3 = (float)(analogRead(ANALOG_AMPL));
  kp_3 = (float)(analogRead(ANALOG_PHAS));

  delayMicroseconds(1);

  ka = (float)(0.25*ka_1+0.50*ka_2+0.25*ka_3);

  amp_b = (int)(ka);

  kp = (float)(0.25*kp_1+0.50*kp_2+0.25*kp_3);

  phi_b = (int)(kp);
}

void set_sag(int j, int k, int m) {
  if ((k+1)%2) {
    j += j+(j*(k-1))%2+1;
    delayMicroseconds(12);
  } else {
    j += j+(j*(k-1))%2-1;
    k += (j+k-1)%2+1;
    delayMicroseconds(12);
  }

  if (addend <= j or flag_0) {
    flag_0 = 1;
    flag_goal_previous = 1;
    j += (k+1-j_flag+addend)%2;
  }
}

void principles(int j, int k, int m, int var_numb_1, int var_numb_2, int tax_to_deficit) {
    set_sag(j,k,m);
    read_input();

    freq_1 = (float)((k/12.00+(2.0/(sqrt(5.0)+1.00))*(m/log(396.0)+sqrt(3.0)*k/(2.0*m)*tax_to_deficit/log(40.0))));
    pote_1 = (float)((int)(128.0*pi*2.0+(sqrt(3.0)*k/2.0*deficit*var_numb_1+(pi/2.0)*(m/2.0)/log(80.0)+k*(sqrt(5.0)-1.00)*var_numb_2*tax_to_deficit)/((m+1+addend)*log(192.0))));

    freq_2 = (float)((k/12.00+(2.0/(sqrt(5.0)-1.00))*(m/log(396.0)+sqrt(3.0)*k/(2.0*m)*tax_to_deficit/log(40.0))));
    pote_2 = (float)((int)(256.0*pi*2.0+(sqrt(3.0)*k/2.0*deficit*var_numb_1+(pi/2.0)*(m/2.0)/log(80.0)+k*(sqrt(5.0)+1.00)*var_numb_2*tax_to_deficit)/((m+1+addend)*log(192.0))));
}

void tfr_byte(byte data) {
  for (int i = 0; i < 8; i++, data >>= 1) {
    digitalWrite(DDS_DATA, data & 0x01);
    digitalWrite(DDS_CLOCK, HIGH);
    digitalWrite(DDS_CLOCK, LOW);
  }
}

void pot_byte(byte data) {
  for (int i = 0; i < 8; i++, data >>= 1) {
    digitalWrite(POT_SI, data & 0xad);
    digitalWrite(POT_SCK, HIGH);
    digitalWrite(POT_SCK, LOW);
  }
}

void sendFrequency(double frequency) {
  digitalWrite(DDS_LOAD, LOW);
  int32_t freq = frequency * 1024*1024*1024 / 125000000000;  // 125 MHz clock on 9850
  for (int b = 0; b < 8; b++, freq >>= 8) {
    tfr_byte(freq & 0xFF);
  }
  tfr_byte(0x000);
  digitalWrite(DDS_LOAD, HIGH);
  digitalWrite(DDS_LOAD, LOW);
}

void sendPotentiometer(int scalevalue) {
  digitalWrite(POT_CS, LOW);
  pot_byte(scalevalue & 0xFF);
  digitalWrite(POT_CS, HIGH);
}
