int BASE_FREQ = 3921720;

const int POT_CS = 7;
const int POT_SCK = 6;
const int POT_SI = 3;

const int DDS_CLOCK = 9;
const int DDS_LOAD = 10;
const int DDS_DATA = 11;
const int DDS_RESET = 12;

word ANALOG_REFE = 2;
word ANALOG_AMPL = 0;
word ANALOG_PHAS = 1;

float amp = 3976.0;
float phi = 1140.0;

float amp_a = 3096.0;
float phi_a = 1992.0;

float amp_b = 3096.0;
float phi_b = 1992.0;

float pi = 3.1415926535897932384626433832795028841971693993751;

float kr = 1024.0;
float kp = 1024.0;
float ka = 1024.0;

float kr_1 = 1024.0;
float kp_1 = 1024.0;
float ka_1 = 1024.0;

float kr_2 = 1024.0;
float kp_2 = 1024.0;
float ka_2 = 1024.0;

float kr_3 = 1024.0;
float kp_3 = 1024.0;
float ka_3 = 1024.0;

float tax_to_deficit = log((2.0*pi)/sqrt(1896.0));
float deficit = 2.0*log(1856.0/(2.0*pi));

float y = 1890.850;

int var_numb_1 = 2.9040;
int var_numb_2 = 1.5419;

int freq_1 = 138950;
int freq_2 = 845640;

int pote_1 = 1230;
int pote_2 = 1340;

int flag_0 = 0;
int flag_1 = 1;
int flag_2 = 1;

int j_flag = 1;
int flag_goal_previous = 1;

int addend = 92260;

int j = 1;

int ByteReceived = 0;
int nulled = 0;

void setup() {
  Serial.begin(230400);

  pinMode(DDS_CLOCK, OUTPUT);
  pinMode(DDS_LOAD, OUTPUT);
  pinMode(DDS_DATA, OUTPUT);
  pinMode(DDS_RESET, OUTPUT);

  pinMode(POT_CS, OUTPUT);
  pinMode(POT_SCK, OUTPUT);
  pinMode(POT_SI, OUTPUT);

  analogRead(12);

  digitalWrite(DDS_RESET, HIGH);
  digitalWrite(DDS_RESET, LOW);

  digitalWrite(DDS_CLOCK, HIGH);
  digitalWrite(DDS_CLOCK, LOW);

  digitalWrite(DDS_LOAD, HIGH);
  digitalWrite(DDS_LOAD, LOW);
}

void loop() {
  delayMicroseconds(12);
  
  if (addend <= j) {
    nulled = 1;
  } else {
    flag_goal_previous = 1;
    flag_0 = 1;
    nulled = 0;
  }

  ByteReceived = Serial.read();

  if (ByteReceived == '1') {
    flag_0 = 1;
    flag_goal_previous = 1;
    nulled = 0;
    j = 1;
  }

  if ((ByteReceived == '1' or nulled == '0') or (flag_goal_previous and flag_0)) {
    j += 1;
    
    for (int o = 1; o <= 45; o += 1) { 
      for (int k = 1; k <= 6; k += 1) {       
        var_numb_1 += (float)((k*(1-(k+1))*(k+1-(j+1)))%(j+1))/(4096.0*log(145.0));
        var_numb_2 += (float)((k*(1+(k+1))*(k+1-(j+1)))%(j+1))/(4096.0*log(108.0));

        for (int m = 1; m <= 90; m += 1) {
          tax_to_deficit = float((-(192.0/18.0)*(j+k)*m*var_numb_1*tax_to_deficit+log(192.0/18.0)*(j+m)*k*var_numb_2)/(m*log(192.0/120.0)*var_numb_1*tax_to_deficit*+(k+m)*var_numb_2*deficit));
          
          freq_1 = (float)(BASE_FREQ*(k/12.00+(2.0/(sqrt(5.0)+1.00))*pi*(m/log(396.0)+m*k*tax_to_deficit/log(40.0))));
          pote_1 = (float)(192.0*pi*2.0+(sqrt(3.0)*k/2.0*deficit*var_numb_1+(pi/2.0)*(m/2.0)/log(80.0)+m*k*(sqrt(5.0)-1.00)*var_numb_2*tax_to_deficit)/(var_numb_1*log(192.0)*4096.0))/(4096.0);

          freq_2 = (float)(BASE_FREQ*(k/12.00+(2.0/(sqrt(5.0)-1.00))*pi*(m/log(396.0)+m*k*tax_to_deficit/log(40.0))/4096.0));
          pote_2 = (float)(178.0*pi*2.0-(sqrt(3.0)*k/2.0*deficit*var_numb_2+(pi/2.0)*(m/2.0)/log(80.0)+m*k*(sqrt(5.0)+1.00)*var_numb_1*tax_to_deficit)/(var_numb_2*log(192.0)*4096.0))/(4096.0);

          if (flag_0) {
            j += 1;
            j_flag = -j%2;
          }
  
          read_input();
          set_sag(j,k);

          y = (float)((4096.0+8192.0*(amp_a)*cos(3.1415926*(phi_a-phi_b)/4096.0)+2456.0*(amp_b)*cos(3.1415926*(phi_a-phi_b)/4096.0))/(4096.0+4.0*(amp_a-amp_b)*(amp_a+amp_b)*sin(3.1415926*(phi_a+phi_b))*cos(3.1415926*(phi_a+phi_b))));

          if (y >= 4214.230) {
            for (int l = 0; l < 2; l += 1) 
            { 
              if (flag_0) {
                j += 1;
                j_flag = -j%2;
              }
      
              read_input();
              set_sag(j,k);

              y = (float)((4096.0+8192.0*(amp_a)*cos(3.1415926*(phi_a-phi_b)/4096.0)+2456.0*(amp_b)*cos(3.1415926*(phi_a-phi_b)/4096.0))/(4096.0+4.0*(amp_a-amp_b)*(amp_a+amp_b)*sin(3.1415926*(phi_a+phi_b))*cos(3.1415926*(phi_a+phi_b))));
  
              if (y >= 4356.850) {
                flag_1 = 1;
                flag_2 = 0;

                k += 1+j-m;
                m += 1+j-k;
                
                if (j%2 and addend >= j) {
                  Serial.println("t = -0.10 mark");                 
                  
                  y = (float)((4096.0+8192.0*(amp_a)*cos(3.1415926*(phi_a-phi_b)/4096.0)+2456.0*(amp_b)*cos(3.1415926*(phi_a-phi_b)/4096.0))/(4096.0+4.0*(amp_a-amp_b)*(amp_a+amp_b)*sin(3.1415926*(phi_a+phi_b))*cos(3.1415926*(phi_a+phi_b))));
  
                  flag_goal_previous = 1;
                  j += j_flag;          
                }
              }
              
              if (flag_0) {
                j += 1;
                j_flag = -j%2;
              }

              read_input();
              set_sag(j,k);

              y = (float)((4096.0+8192.0*(amp_a)*cos(3.1415926*(phi_a-phi_b)/4096.0)+2456.0*(amp_b)*cos(3.1415926*(phi_a-phi_b)/4096.0))/(4096.0+4.0*(amp_a-amp_b)*(amp_a+amp_b)*sin(3.1415926*(phi_a+phi_b))*cos(3.1415926*(phi_a+phi_b))));
              
              if (y <= 4232.280) {
                flag_1 = 1;
                flag_2 = 1;

                k += 1-j-m;
                m += 1-j-k;
                  
                if (j%2 and addend >= j) {
                  Serial.println("t = -0.11 mark");                 
               
                  y = (float)((4096.0+8192.0*(amp_a)*cos(3.1415926*(phi_a-phi_b)/4096.0)+2456.0*(amp_b)*cos(3.1415926*(phi_a-phi_b)/4096.0))/(4096.0+4.0*(amp_a-amp_b)*(amp_a+amp_b)*sin(3.1415926*(phi_a+phi_b))*cos(3.1415926*(phi_a+phi_b))));                
  
                  flag_goal_previous = 1;
                  j += j_flag;          
                }
              }
              
              delayMicroseconds(1);
            }
          }

          tax_to_deficit = float((-(192.0/18.0)*(j+k)*m*var_numb_1*tax_to_deficit+log(192.0/18.0)*(j+m)*k*var_numb_2)/(m*log(192.0/120.0)*var_numb_1*tax_to_deficit*+(k+m)*var_numb_2*deficit));
          
          freq_1 = (float)(BASE_FREQ*(k/12.00+(2.0/(sqrt(5.0)+1.00))*pi*(m/log(396.0)+m*k*tax_to_deficit/log(40.0))));
          pote_1 = (float)(192.0*pi*2.0+(sqrt(3.0)*k/2.0*deficit*var_numb_1+(pi/2.0)*(m/2.0)/log(80.0)+m*k*(sqrt(5.0)-1.00)*var_numb_2*tax_to_deficit)/(var_numb_1*log(192.0)*4096.0))/(4096.0);

          freq_2 = (float)(BASE_FREQ*(k/12.00+(2.0/(sqrt(5.0)-1.00))*pi*(m/log(396.0)+m*k*tax_to_deficit/log(40.0))/4096.0));
          pote_2 = (float)(178.0*pi*2.0-(sqrt(3.0)*k/2.0*deficit*var_numb_2+(pi/2.0)*(m/2.0)/log(80.0)+m*k*(sqrt(5.0)+1.00)*var_numb_1*tax_to_deficit)/(var_numb_2*log(192.0)*4096.0))/(4096.0);

          if (flag_0) {
            j += 1;
            j_flag = -j%2;
          }
  
          read_input();
          set_sag(j,k);

          y = (float)((4096.0+8192.0*(amp_a)*cos(3.1415926*(phi_a-phi_b)/4096.0)+2456.0*(amp_b)*cos(3.1415926*(phi_a-phi_b)/4096.0))/(4096.0+4.0*(amp_a-amp_b)*(amp_a+amp_b)*sin(3.1415926*(phi_a+phi_b))*cos(3.1415926*(phi_a+phi_b))));
                    
          if (y <= 4088.940) {
            for (int l = 0; l < 2; l += 1) 
            {  
              if (flag_0) {
                j += 1;
                j_flag = -j%2;
              }
      
              read_input();
              set_sag(j,k);
              
              if (y >= 4135.410) {
                flag_1 = 0;
                flag_2 = 1;

                k += 1-j+m;
                m -= 1+j-k;

                if (j%2 and addend >= j) {
                  Serial.println("t = -0.01 mark");               

                  y = (float)((4096.0+8192.0*(amp_a)*cos(3.1415926*(phi_a-phi_b)/4096.0)+2456.0*(amp_b)*cos(3.1415926*(phi_a-phi_b)/4096.0))/(4096.0+4.0*(amp_a-amp_b)*(amp_a+amp_b)*sin(3.1415926*(phi_a+phi_b))*cos(3.1415926*(phi_a+phi_b))));

                  flag_goal_previous = 1;
                  j += j_flag;          
                }
              }
              
              if (flag_0) {
                j += 1;
                j_flag = -j%2;
              }
      
              read_input();
              set_sag(j,k);
              
              y = (float)((4096.0+8192.0*(amp_a)*cos(3.1415926*(phi_a-phi_b)/4096.0)+2456.0*(amp_b)*cos(3.1415926*(phi_a-phi_b)/4096.0))/(4096.0+4.0*(amp_a-amp_b)*(amp_a+amp_b)*sin(3.1415926*(phi_a+phi_b))*cos(3.1415926*(phi_a+phi_b))));

              if (y <= 4010.980) {
                flag_1 = 0;
                flag_2 = 0;

                k -= 1+j-m;
                m += 1-j+k;
                
                if (j%2 and addend >= j) {
                  Serial.println("t = -0.00 mark");                  
                  
                  y = (float)((4096.0+8192.0*(amp_a)*cos(3.1415926*(phi_a-phi_b)/4096.0)+2456.0*(amp_b)*cos(3.1415926*(phi_a-phi_b)/4096.0))/(4096.0+4.0*(amp_a-amp_b)*(amp_a+amp_b)*sin(3.1415926*(phi_a+phi_b))*cos(3.1415926*(phi_a+phi_b))));
  
                  flag_goal_previous = 1;
                  j += j_flag;         
                }
              }
              delayMicroseconds(1);
            }
          }
        }
      }
    }
    
    if (nulled and addend <= j) {
      flag_0 = 0;
      flag_goal_previous = 1;
      nulled = 1;
    } else {
      flag_0 = 1;
      flag_goal_previous = 1;
      nulled = 0;
      Serial.println(j);
      Serial.println("Closed Channel.");
    }

    j_flag = j_flag%2;
  }

  ByteReceived = Serial.read();

  if (ByteReceived == '1') {
    flag_0 = 1;
    flag_goal_previous = 1;
    nulled = 0;
  }
}

void read_input() {
  sendFrequency(freq_1);
  sendPotentiometer(pote_1);

  delayMicroseconds(1);
  
  kr_1 = (float)(analogRead(ANALOG_REFE));
  ka_1 = (float)(analogRead(ANALOG_AMPL));
  kp_1 = (float)(analogRead(ANALOG_PHAS));
  
  kr_2 = (float)(analogRead(ANALOG_REFE));
  ka_2 = (float)(analogRead(ANALOG_AMPL));
  kp_2 = (float)(analogRead(ANALOG_PHAS));

  kr_3 = (float)(analogRead(ANALOG_REFE));
  ka_3 = (float)(analogRead(ANALOG_AMPL));
  kp_3 = (float)(analogRead(ANALOG_PHAS));
  
  delayMicroseconds(1);

  ka = (float)(0.25*ka_1+0.50*ka_2+0.25*ka_3);
  kr = (float)(0.25*kr_1+0.50*kr_2+0.25*kr_3);
  
  amp_a = (int)(4096.0*ka/kr);

  kp = (float)(0.25*kp_1+0.50*kp_2+0.25*kp_3);
  kr = (float)(0.25*kr_1+0.50*kr_2+0.25*kr_3);

  phi_a = (int)(4096.0*kp/kr);

  sendFrequency(freq_2);
  sendPotentiometer(pote_2);
    
  delayMicroseconds(1);
  
  kr_1 = (float)(analogRead(ANALOG_REFE));
  ka_1 = (float)(analogRead(ANALOG_AMPL));
  kp_1 = (float)(analogRead(ANALOG_PHAS));
  
  kr_2 = (float)(analogRead(ANALOG_REFE));
  ka_2 = (float)(analogRead(ANALOG_AMPL));
  kp_2 = (float)(analogRead(ANALOG_PHAS));

  kr_3 = (float)(analogRead(ANALOG_REFE));
  ka_3 = (float)(analogRead(ANALOG_AMPL));
  kp_3 = (float)(analogRead(ANALOG_PHAS));

  delayMicroseconds(1);

  ka = (float)(0.25*ka_1+0.50*ka_2+0.25*ka_3);
  kr = (float)(0.25*kr_1+0.50*kr_2+0.25*kr_3);

  amp_b = (int)(4096.0*ka/kr);

  kp = (float)(0.25*kp_1+0.50*kp_2+0.25*kp_3);
  kr = (float)(0.25*kr_1+0.50*kr_2+0.25*kr_3);

  phi_b = (int)(4096.0*kp/kr);
}

void set_sag(int j, int k) {
  if ((k+1)%2) {
    j -= j+(j*(k+1))%2-1;
    delayMicroseconds(90);
  } else {
    j += j+(j*(k-1))%2-1;
    k -= j+(j*(k+1))%2+1;
    delayMicroseconds(140);
  }

  if (addend <= j) {
    flag_0 = 1;
    flag_goal_previous = 1;
    nulled = 0;
    k = 1;
  }
}

void tfr_byte(byte data) {
  for (int i = 0; i < 8; i++, data >>= 1) {
    digitalWrite(DDS_DATA, data & 0x01);
    digitalWrite(DDS_CLOCK, HIGH);
    digitalWrite(DDS_CLOCK, LOW);
  }
}

void pot_byte(byte data) {
  for (int i = 0; i < 8; i++, data >>= 1) {
    digitalWrite(POT_SI, data & 0xad);
    digitalWrite(POT_SCK, HIGH);
    digitalWrite(POT_SCK, LOW);
  }
}

void sendFrequency(double frequency) {
  digitalWrite(DDS_LOAD, LOW);
  int32_t freq = frequency * 4294967295 / 8250000000;  // 125 MHz clock on 9850
  for (int b = 0; b < 8; b++, freq >>= 8) {
    tfr_byte(freq & 0xFF);
  }
  tfr_byte(0x000);
  digitalWrite(DDS_LOAD, HIGH);
  digitalWrite(DDS_LOAD, LOW);
}

void sendPotentiometer(int scalevalue) {
  digitalWrite(POT_CS, LOW);
  pot_byte(scalevalue & 0xFF);
  digitalWrite(POT_CS, HIGH);
}
