import serial
import sys
import time
import pylab as pl
import numpy as np
from matplotlib import pyplot as plt
from matplotlib import animation
from scipy import *
from scipy.special import eval_hermitenorm

fig, ax = plt.subplots(figsize=(5, 3))
ax.set(xlim=(0,120),ylim=(0,120))

pi = 3.1415926535898

x_range = 60
y_range = 60

alpha = 3.6835
beta = 1.8591

grad = np.sqrt(1.681)*np.sqrt(pi/2.0)   #1.593
scale = np.sqrt(2.0*pi)/np.log(20.0)   #0.739
scale_var = 2.0*scale/np.sqrt(x_range)  #.013

samples = 4
cls_write = 480

def fac(n):
    result = 1.0
    if n == 0:
        return 1
    else:       
        for x in range(1,n+1,1):
            result = result*x
        return result

def phi_map(phi_range):
   phi = []
   for x in range(phi_range*2):
      phi.append([])
   return phi

def amp_map(amp_range):
   amp = []
   for x in range(amp_range*2):
      amp.append([])
   return amp

def functional_mapping(m,rho,theta,phi_val):
    one = np.sqrt(m+1)/(2**(m)*fac(m))*eval_hermitenorm(m+l,rho*scale*(m+1))*np.exp(-(rho*scale*(m+1))**2)*np.cos(theta+phi_val[m])
    return one

def functional_map(tat, pos_x, pos_y, scale):
   value = 0.0
   
   rho = scale_var*np.lib.scimath.sqrt(pos_x**2+pos_y**2)
   theta = np.arctan2(pos_x,pos_y)
   
   phi1_val = tat[0]
   amp1_val = tat[1]
   phi2_val = tat[2]
   amp2_val = tat[3]
   
   phi_val = np.subtract(phi2_val,phi1_val)
   amp_val = np.subtract(amp2_val,amp1_val)
   
   for m in range(mode):
       value += amp_val[m]*functional_mapping(m,rho,theta,phi_val)
           
   return value

def get_value(pos_x, pos_y, tat, scale): 
    return functional_map(tat, pos_x, pos_y, scale)

def take_data(phi1_values, amp1_values, phi2_values, amp2_values, samples):
    ser.write(bytes("1", 'utf-8'))
    let = ser.read(cls_write)
    roger = [int(s) for s in let.split() if s.isdigit()]
    
    for k in range(samples):
        for j in range(0,(k-1)*2+8-1,+1):
            if j < 10:
                if k < 10:
                    mode_1 = roger[0+(k+j-1)*3]
                    mode_2 = roger[4+(k+j-1)*3]
                    amp = roger[10+(k+j-1)*6]
                    phi = roger[16+(k+j-1)*6]
                    mode = mode_2*3+mode_1*2+1
                    print(mode)
                    amp1_values[mode] = 10**(-grad*float(amp/4096.0))
                    phi1_values[mode] = pi*float(phi/4096.0)
                else:
                    mode_1 = roger[0+(k+j-1)*4]
                    mode_2 = roger[40+(k+j-1)*3]
                    amp = roger[70+(k+j-1)*6]
                    phi = roger[76+(k+j-1)*6]
                    mode = mode_2*3+mode_1*2+1
                    print(mode)
                    amp1_values[mode] = 10**(-grad*float(amp/4096.0))
                    phi1_values[mode] = pi*float(phi/4096.0)
            else:
                if k < 10:
                    mode_1 = roger[0+(k+j-1)*3]
                    mode_2 = roger[3+(k+j-1)*4]
                    amp = roger[43+(k+j-1)*6]
                    phi = roger[49+(k+j-1)*6]
                    mode = mode_2*3+mode_1*2+1
                    print(mode)
                    amp1_values[mode] = 10**(-grad*float(amp/4096.0))
                    phi1_values[mode] = pi*float(phi/4096.0)
                else:
                    mode_1 = roger[0+(k+j-1)*4]
                    mode_2 = roger[4+(k+j-1)*4]
                    amp = roger[84+(k+j-1)*6]
                    phi = roger[90+(k+j-1)*6]
                    mode = mode_2*3+mode_1*2+1
                    print(mode)
                    amp1_values[mode] = 10**(-grad*float(amp/4096.0))
                    phi1_values[mode] = pi*float(phi/4096.0)
        
    ser.write(bytes("1", 'utf-8'))
    let = ser.read(cls_write)
    roger = [int(s) for s in let.split() if s.isdigit()]
    
    for k in range(samples):
        for j in range(0,(k-1)*2+8-1,+1):
            if j < 10: 
                if k < 10:
                    mode_1 = roger[0+(k+j-1)*3]
                    mode_2 = roger[4+(k+j-1)*3]
                    amp = roger[10+(k+j-1)*6]
                    phi = roger[16+(k+j-1)*6]
                    mode = mode_2*3+mode_1*2+1
                    print(mode)
                    amp1_values[mode+1] = 10**(-grad*float(amp/4096.0))
                    phi1_values[mode+1] = pi*float(phi/4096.0)
                else:
                    mode_1 = roger[0+(k+j-1)*4]
                    mode_2 = roger[40+(k+j-1)*3]
                    amp = roger[70+(k+j-1)*6]
                    phi = roger[76+(k+j-1)*6]
                    mode = mode_2*3+mode_1*2+1
                    print(mode)
                    amp1_values[mode+1] = 10**(-grad*float(amp/4096.0))
                    phi1_values[mode+1] = pi*float(phi/4096.0)
            else:
                if k < 10:
                    mode_1 = roger[0+(k+j-1)*3]
                    mode_2 = roger[3+(k+j-1)*4]
                    amp = roger[43+(k+j-1)*6]
                    phi = roger[49+(k+j-1)*6]
                    mode = mode_2*3+mode_1*2+1
                    print(mode)
                    amp1_values[mode+1] = 10**(-grad*float(amp/4096.0))
                    phi1_values[mode+1] = pi*float(phi/4096.0)
                else:
                    mode_1 = roger[0+(k+j-1)*4]
                    mode_2 = roger[4+(k+j-1)*4]
                    amp = roger[84+(k+j-1)*6]
                    phi = roger[90+(k+j-1)*6]
                    mode = mode_2*3+mode_1*2+1
                    print(mode)
                    amp1_values[mode+1] = 10**(-grad*float(amp/4096.0))
                    phi1_values[mode+1] = pi*float(phi/4096.0)
                
    return [phi1_values, amp1_values, phi2_values, amp2_values]

def animate(i):
   ser.open()
   newdata = take_data(phi1_values, amp1_values, phi2_values, amp2_values, samples)
   ser.close()
   Z = get_value(X,Y,newdata,scale)
   im.set_data(Z)
   return [im]

ser = serial.Serial(
   port = 'COM5',
   baudrate = 115200,
   parity = serial.PARITY_NONE,
   stopbits = serial.STOPBITS_ONE,
   bytesize = serial.EIGHTBITS,
   timeout = 1
)

phi1_values = phi_map(samples)
amp1_values = amp_map(samples)
phi2_values = phi_map(samples)
amp2_values = amp_map(samples)

phi_values = phi_map(samples)
amp_values = amp_map(samples)

ser.write(bytes("1", 'utf-8'))
let = ser.read(cls_write)
roger1 = [int(s) for s in let.split() if s.isdigit()]

for k in range(samples):
    for j in range(0,(k-1)*2+8-1,+1):
        if j < 10:
            if k < 10:
                mode_1 = roger1[0+(k+j-1)*3]
                mode_2 = roger1[4+(k+j-1)*3]
                amp = roger1[10+(k+j-1)*6]
                phi = roger1[16+(k+j-1)*6]
                mode = mode_2*3+mode_1*2+1
                print(mode)
                amp_values[mode+1] = 10**(-grad*float(amp/4096.0))
                phi_values[mode+1] = pi*float(phi/4096.0)
            else: 
                mode_1 = roger1[0+(k+j-1)*4]
                mode_2 = roger1[40+(k+j-1)*3]
                amp = roger1[70+(k+j-1)*6]
                phi = roger1[76+(k+j-1)*6]
                mode = mode_2*3+mode_1*2+1
                print(mode)
                amp_values[mode+1] = 10**(-grad*float(amp/4096.0))
                phi_values[mode+1] = pi*float(phi/4096.0)
        else:
            if k < 10:
                mode_1 = roger1[0+(k+j-1)*3]
                mode_2 = roger1[3+(k+j-1)*4]
                amp = roger1[43+(k+j-1)*6]
                phi = roger1[49+(k+j-1)*6]
                mode = mode_2*3+mode_1*2+1
                print(mode)
                amp_values[mode+1] = 10**(-grad*float(amp/4096.0))
                phi_values[mode+1] = pi*float(phi/4096.0)
            else:
                mode_1 = roger1[0+(k+j-1)*4]
                mode_2 = roger1[4+(k+j-1)*4]
                amp = roger1[84+(k+j-1)*6]
                phi = roger1[90+(k+j-1)*6]
                mode = mode_2*3+mode_1*2+1
                print(mode)
                amp_values[mode+1] = 10**(-grad*float(amp/4096.0))
                phi_values[mode+1] = pi*float(phi/4096.0)

time.sleep(2)

ser.write(bytes("1", 'utf-8'))
let = ser.read(cls_write)
roger2 = [int(s) for s in let.split() if s.isdigit()]

for k in range(samples):
    for j in range(0,(k-1)*2+8-1,+1):
        if j < 10:
            if k < 10:
                mode_1 = roger2[0+(k+j-1)*3]
                mode_2 = roger2[4+(k+j-1)*3]
                amp = roger2[10+(k+j-1)*6]
                phi = roger2[16+(k+j-1)*6]
                mode = mode_2*3+mode_1*2+1
                print(mode)
                amp_values[mode+1] = 10**(-grad*float(amp/4096.0))
                phi_values[mode+1] = pi*float(phi/4096.0)
            else:
                mode_1 = roger2[0+(k+j-1)*4]
                mode_2 = roger2[40+(k+j-1)*3]
                amp = roger2[70+(k+j-1)*6]
                phi = roger2[76+(k+j-1)*6]
                mode = mode_2*3+mode_1*2+1
                print(mode)
                amp_values[mode+1] = 10**(-grad*float(amp/4096.0))
                phi_values[mode+1] = pi*float(phi/4096.0)
        else:
            if k < 10:
                mode_1 = roger2[0+(k+j-1)*3]
                mode_2 = roger2[3+(k+j-1)*4]
                amp = roger2[43+(k+j-1)*6]
                phi = roger2[49+(k+j-1)*6]
                mode = mode_2*3+mode_1*2+1
                print(mode)
                amp_values[mode+1] = 10**(-grad*float(amp/4096.0))
                phi_values[mode+1] = pi*float(phi/4096.0)
            else:
                mode_1 = roger2[0+(k+j-1)*4]
                mode_2 = roger2[4+(k+j-1)*4]
                amp = roger2[84+(k+j-1)*6]
                phi = roger2[90+(k+j-1)*6]
                mode = mode_2*3+mode_1*2+1
                print(mode)
                amp_values[mode+1] = 10**(-grad*float(amp/4096.0))
                phi_values[mode+1] = pi*float(phi/4096.0)
    
max_index = 2000000

newdata = take_data(phi1_values, amp1_values, phi2_values, amp2_values, samples)
data = [phi1_values, amp1_values, phi2_values, amp2_values]

x = np.arange(-x_range,x_range,1)
y = np.arange(-y_range,y_range,1)
X, Y = np.meshgrid(x,y)

Z = get_value(X,Y,data,scale)

im = plt.imshow(Z, cmap='bone', origin='lower', vmin=-0.0005, vmax=0.0005)

ani = animation.FuncAnimation(fig, animate, frames=max_index)
plt.colorbar()
plt.show()
ser.close()