import mido
from mido import Message
import pigpio
from numpy import interp
#!/usr/bin/env python3
import time
import pyfirmata

class free:
    def __init__(self, port, board, freq):
        self.freq = freq
        self.frequency = freq*2000000.0
        self.port = port
        self.board = board

        self.POT_CS = 5
        self.POT_SCK = 6
        self.POT_SI = 7

        self.DDS_CLOCK = 8
        self.DDS_LOAD = 9
        self.DDS_DATA = 10
        self.DDS_RESET = 11
    
        self.board.digital[self.DDS_RESET].write(1);
        self.board.digital[self.DDS_RESET].write(0);
  
        self.board.digital[self.DDS_CLOCK].write(1);
        self.board.digital[self.DDS_CLOCK].write(0);

        self.board.digital[self.DDS_LOAD].write(1);
        self.board.digital[self.DDS_LOAD].write(0);

    def tfr_bit(self,data):
        for j in range(data):
            self.board.digital[self.DDS_DATA].write(data)
            self.board.digital[self.DDS_CLOCK].write(1)
            self.board.digital[self.DDS_CLOCK].write(0)
            
    def pot_bit(self,data):
        for j in range(data):
            self.board.digital[self.POT_SI].write(data)
            self.board.digital[self.POT_SCK].write(1)
            self.board.digital[self.POT_SCK].write(0)

    def send_freq(self,freq):
        self.board.digital[self.DDS_LOAD].write(0)
        self.frequency = int(freq*(2**24/125000000))
        for j in range(self.frequency):
            self.tfr_bit(self.frequency)
            self.tfr_bit(0x000)
            self.board.digital[self.DDS_LOAD].write(1)
            self.board.digital[self.DDS_LOAD].write(0)
        
    def sendPotentiometer(self,scalevalue):
        scale = int(scalevalue)
        self.board.digital[self.POT_CS].write(0)
        self.pot_bit(scale)
        self.board.digital[self.POT_CS].write(1)

freq = 1

pi1 = pigpio.pi()
port = mido.open_input('Arturia KeyStep 32 MIDI 1')

board = pyfirmata.Arduino('/dev/ttyACM1')
print("Communication Successfully started")

u = free(port, board, freq)

while True:
    msg = u.port.receive() # if there is a message pending
    print(msg)
    out = interp(msg.velocity, [0,127],[0,255]) # scale velocity from 0-127 to 0-255                       # filter the data by note number
    freq = int(msg.note)
    u.send_freq(freq)
    u.sendPotentiometer(int(4.0+15.0*freq/10.0))
    print('Frequency')
    print(freq*2000000.0/10.0)
    print('Potentiometer')
    print(int(4.0+15.0*freq/10.0))
