from NumericUnitCell import *
from VisualSphere import *

from visual import *
from random import random
import time,sys,thread

scene.title = "Simulation"
scene.width = 800
scene.height = 720
scene.x = 20
scene.y = 20
scene.autoscale = 1
scene.up = (0,0,1)
scene.fov = pi/30.0
scene.forward = (0.0,1.0,-1.0)
scene.lights = [vector(.5,.5,.5), vector(-.5,-.5,-.5)]
scene.background = (0,0,0)
scene.uniform = 1
scene.range = 1.0
##        scene.stereo = 'passive'
scene.select()

##equatorLine = curve(x=cos(arange(0,2.1*pi,.1565)), y=sin(arange(0,2.1*pi,.1565)), color=(.5,.5,.5))

print '-----------------------------'

dt = .0003
numLoops = 63                       # number of loops, each one can be random, for instance.
numFrames = 255                     # Number of frames
frameDuty = 63                      # Number of cycles per animation frame
simuLength = numFrames*frameDuty    # Total time for simu, because I used nested for loops.


nSpinsX = 2
nSpinsY = 3
uc = NumericUnitCell(nSpinsX,nSpinsY)
vSphere = VisualSphere(nSpinsX,nSpinsY)

Ja = -1.0
Jbx = -1.0
Jby = 4.90
uc.setCouplings(Ja, Jbx, Jby)

temp = 0.0*abs(Ja)

k = 3.1416*vector(0.0,0.25,0.0)
baseSigma = .5
uc.setState(k, baseSigma)


uc.permuteState(dt)
scene.forward = uc.getCommonAxis()

visAxis = []
for x in arange(-2.0,2.01,1.0):
    visAxis.append(x*norm(uc.getCommonAxis()))
axisLine = curve(pos=visAxis, color=(.8,.8,.8))


for i in range(numLoops):
    vSphere.addPoints(uc.getState())
    vSphere.addVectors(uc.getState())
    vSphere.addTracers(uc.getState())

    for j in range(numFrames):

        for k in range(frameDuty):
            uc.permuteState(dt)
            uc.perturbState(dt,temp,Ja)
            vSphere.updatePoints(uc.getState())

        vSphere.updateTracers(uc.getState())
        
    vSphere.resetVisuals()
    del vSphere
    vSphere = VisualSphere(nSpinsX,nSpinsY)
    
    uc.randomizeState()                         # Randomize between sessions...
    scene.forward = uc.getCommonAxis()



