from scipy import *
from numpy import *

sumModesN = 55
Z = 1

def stringarraytoarray(lineread, sizeSquare):
    dummy2 = lineread.replace(',','')
    dummy3 = dummy2.replace(']','')
    dummy4 = dummy3.replace('[','')
    dummyFinal = dummy4.split()

    target = [None]*sumModesN
    m = 0
    for i in range(sumModesN):
        target[i] = [0]*sumModesN
        for j in range(sumModesN):
            if abs(float(dummyFinal[m]))>10**-12:
                target[i][j] = float(dummyFinal[m])
            else:
                target[i][j] = 0.0
            m += 1
    return array(target)


kineticFile = open("dumpkinetic", mode='r')
kineticReadLine = kineticFile.readline()
kineticArray = stringarraytoarray(kineticReadLine,sumModesN)
kineticFile.close()
print "\nKinetic Array\n"
print shape(kineticArray)
print kineticArray

nuclearFile = open("dumpnuclear", mode='r')
nuclearReadLine = nuclearFile.readline()
nuclearArray = stringarraytoarray(nuclearReadLine,sumModesN)
nuclearFile.close()
print "\nNuclear Array\n"
print shape(nuclearArray)
print nuclearArray


realTotalArray = Z*nuclearArray + kineticArray
output = linalg.eig(realTotalArray)

print "\nEigenvalues:\n"
print output[0]

print "\nEigenvalues in eV:\n"
print output[0]*27.2113897

print "\nEigenvectors:\n"
print output[1:sumModesN]
