from scipy import *
from numpy import *

class basisWaveFunction:
    def __init__(self,n,l):
        self.n = n
        self.l = l
        self.anaught = 1.0

    def fullRadialWavefunction(r,n,l):
        return special.genlaguerre(n-l-1,2l+1)(2*r/(n*self.anaught))*exp(-r/(n*self.anaught))*(r/(n*self.anaught))**l

    def normedFullRadialWavefunction(r,n,l):
        return sqrt(1/N[0])*special.genlaguerre(n-l-1,2l+1)(2*r/(n*self.anaught))*exp(-r/(n*self.anaught))*(r/(n*self.anaught))**l

    def normedFullRadialWavefunctionDensity(r,n,l):
        return (r*normedFullRadialWavefunction(r,n,l))**2

    def normalize(self,n,l):
        N = integrate.quad(lambda r: r**2*fullRadialWavefunction(r,n,l)**2, 0, Inf)
        return integrate.quad(lambda r: normedFullRadialWavefunctionDensity(r,n,l), 0, Inf)
