from visual import *
from visual.graph import *


class AnglePlot:
    def __init__(self, nSpinsX, nSpinsY, nLattice):
        self.window = display(title='Angle Plots', xtitle='t', ytitle='Angle', width=480, height=250, x=5, y=800, xmin=0.0, xmax=100.0, ymin=0.0, ymax=3.15, background=(0.0,0.0,0.0), visible=0)

        self.tvWindow = 0
        self.window.visible = self.tvWindow

        self.angleCurveA = curve(color=color.red, visible=self.tvWindow)
        self.angleCurveB = curve(color=color.green, visible=self.tvWindow)
        self.angleCurveC = curve(color=color.blue, visible=self.tvWindow)

        self.nSpinsX = nSpinsX
        self.nSpinsY = nSpinsY

        self.nLattice = nLattice



          
    def updateCurves(self,t):
        if self.tvWindow == 0:
            self.tvWindow = 1
            self.window.visible = self.tvWindow

            self.angleCurveA.visible = self.tvWindow
            self.angleCurveB.visible = self.tvWindow
            self.angleCurveC.visible = self.tvWindow
        
        spinArray = self.nLattice.spinArray
        
        dotA = float(dot(spinArray[0][0][0],spinArray[1][0][0]))
        dotB = float(dot(spinArray[1][0][0],spinArray[2][0][0]))
        dotC = float(dot(spinArray[2][0][0],spinArray[0][0][0]))

        if abs(dotA) < 1.0:     diffAngleA = arccos(dotA)
        else:                   diffAngleA = pi
        if abs(dotB) < 1.0:     diffAngleB = arccos(dotB)
        else:                   diffAngleB = pi
        if abs(dotC) < 1.0:     diffAngleC = arccos(dotC)
        else:                   diffAngleC = pi

        diffAngleB = (pi-diffAngleB)/.1
               
#        self.angleCurveA.plot(pos=(t,diffAngleA))
        self.angleCurveB.plot(pos=(t,diffAngleB))
#        self.angleCurveC.plot(pos=(t,diffAngleC))

        self.window.minmax[0][1] = t+0.1
        self.window.setrangex()


    def toggleWindow(self):
        self.tvWindow = (self.tvWindow+1)%2

        if self.tvWindow == 1:
            self.window.visible = self.tvWindow
            
            self.angleCurveA.visible = self.tvWindow
            self.angleCurveB.visible = self.tvWindow
            self.angleCurveC.visible = self.tvWindow
        else:
            self.angleCurveA.visible = self.tvWindow
            self.angleCurveB.visible = self.tvWindow
            self.angleCurveC.visible = self.tvWindow

            self.window.visible = self.tvWindow


    def resetPlots(self):
        self.angleCurveA.visible = 0
        self.angleCurveB.visible = 0
        self.angleCurveC.visible = 0

        self.angleCurveA = curve(color=color.red, visible=self.tvWindow)
        self.angleCurveB = curve(color=color.green, visible=self.tvWindow)
        self.angleCurveC = curve(color=color.blue, visible=self.tvWindow)


