from visual import *
from random import random

import time,sys,thread

spinSphereW = display(title='Spin Sphere', width=680, height=600, x=20, y=20, center=(0,0,0), background=(.0,.0,.0))
spinSphereW.fov = pi/10.0
spinSphereW.lights = [vector(.5,.5,.5), vector(-.5,-.5,-.5)]

spinSphereW.up = (0,0,1)
spinSphereW.forward = (0.0,1.0,-1.0)
spinSphereW.range = 1.414
spinSphereW.autoscale = 0
spinSphereW.visible = 1

spinSphereW.select()



equatorLine = curve(x=cos(arange(0,2.1*pi,.1565)), y=sin(arange(0,2.1*pi,.1565)), color=(.5,.5,.5))

##zAxis = []
##for x in arange(-1.4,1.4+.1,1.4):
##    zAxis.append(x*norm(vector(0.0,0.0,1.0)))
##zAxisLine = curve(pos=zAxis, color=(.8,.8,.8))
   


class Tracer:
    tracerLength = 32
    
    tracerPoints = []
    tracerCurve = curve()

    def __init__(self, tracerLength):
        self.tracerLength = tracerLength
        
        tracerPoints = [ None ] * tracerLength              # a vector of null elements, nSpinsX long
        for x in range(tracerLength):
            tracerPoints[x] = [0.0] * 3                     # a vector of zeros nSpinsY long

        self.tracerPoints = tracerPoints
        self.tracerCurve.pos = self.tracerPoints

        
    def stepTracer(self, updatePosition):
        del self.tracerPoints[0]
        self.tracerPoints.append(updatePosition)
        self.tracerCurve.pos = self.tracerPoints

    def delTracer(self):
        for i in range(self.tracerLength):
            self.tracerPoints[i] = [0.0,0.0,0.0]  
        self.tracerCurve.pos = self.tracerPoints

    def getTracer(self):
        return self.tracerPoints




class Spin:
    tracerLength = 32

    tracer = Tracer(tracerLength)
    point = sphere(visible=0)
    vector = arrow(visible=0)
    
    def __init__(self, tracerLength):
        self.tracerLength = tracerLength

        self.tracer = Tracer(tracerLength)
        self.point = sphere(visible=0)
        self.vector = arrow(visible=0)
                
    def delTracer(self):
        self.tracer.delTracer()

    def getTracer(self):
        return self.tracer



 
class VisualSphere:
    visualArray = []

    tracerLength = 32

    toggleTracersVar = 1
    togglePointsVar = 0
    toggleVectorsVar = 0
    
    toggleVectorsPhaseColor = 1

    toggleAxisVar = 0

    spinWaveAxis = []           
    spinWaveAxisLine = curve(color=(.8,.8,.95), visible = toggleAxisVar)
    

    
    def __init__(self, nSpinsX, nSpinsY):
        self.nSpinsX = nSpinsX
        self.nSpinsY = nSpinsY

        visualArray = [ None ] * nSpinsX                               # a vector of null elements, nSpinsX long
        for x in range(nSpinsX):
            visualArray[x] = [0] * nSpinsY                             # a vector of zeros nSpinsY long
            for y in range(nSpinsY):
                visualArray[x][y] = Spin(self.tracerLength)
               
        self.visualArray = visualArray



    def addTracers(self,spinArray):
        for x in range(self.nSpinsX):
            for y in range(self.nSpinsY):
                z = spinArray[x][y][0][2]
                self.visualArray[x][y].tracer.tracerCurve = curve(color=((1+z)/2,0.0,(1-z)/2))

    def updateTracers(self,spinArray):
        for x in range(self.nSpinsX):
            for y in range(self.nSpinsY):
                self.visualArray[x][y].tracer.stepTracer(spinArray[x][y][0])
                
    def resetTracers(self):
        for x in range(self.nSpinsX):
            for y in range(self.nSpinsY):
                self.visualArray[x][y].delTracer()
                
    def toggleTracers(self):
        self.toggleTracersVar = (self.toggleTracersVar+1)%2
        
        for x in range(self.nSpinsX):
            for y in range(self.nSpinsY):
                self.visualArray[x][y].tracer.tracerCurve.visible = self.toggleTracersVar             


##    def changeTracerLength(self, tracerLength):
##        for x in range(self.nSpinsX):
##            for y in range(self.nSpinsY):
##                self.visualArray[x][y].tracer.




    def addPoints(self,spinArray):
        for x in range(self.nSpinsX):
            for y in range(self.nSpinsY):
                z = spinArray[x][y][0][2]
                self.visualArray[x][y].point = sphere(pos=(0.0,0.0,0.0), color=((1+z)/2,0.0,(1-z)/2), radius=0.03, visible=self.togglePointsVar)

    def updatePoints(self,spinArray):
        for x in range(self.nSpinsX):
            for y in range(self.nSpinsY):
                self.visualArray[x][y].point.pos = spinArray[x][y][0]

    def togglePoints(self):
        self.togglePointsVar = (self.togglePointsVar+1)%2
        for x in range(self.nSpinsX):
            for y in range(self.nSpinsY):
                self.visualArray[x][y].point.visible = self.togglePointsVar




    def addVectors(self,spinArray):
        for x in range(self.nSpinsX):
            for y in range(self.nSpinsY):
                z = spinArray[x][y][0][2]
                self.visualArray[x][y].vector = arrow(pos=(0.0,0.0,0.0), axis=spinArray[x][y][0], color=((1+z)/2,0.0,(1-z)/2), shaftwidth=0.025, visible=self.toggleVectorsVar)

    def updateVectors(self,spinArray):
        for x in range(self.nSpinsX):
            for y in range(self.nSpinsY):
                self.visualArray[x][y].vector.axis = spinArray[x][y][0]

    def toggleVectors(self):
        self.toggleVectorsVar = (self.toggleVectorsVar+1)%2
        for x in range(self.nSpinsX):
            for y in range(self.nSpinsY):
                self.visualArray[x][y].vector.visible = self.toggleVectorsVar



 
    def updateAxis(self, axis):
        self.spinWaveAxis = [-1.5*axis,1.5*axis]
        self.spinWaveAxisLine.pos = self.spinWaveAxis

        
    def updateViewAxis(self, axis):
        spinSphereW.forward = axis


    def toggleAxis(self):
        self.toggleAxisVar = (self.toggleAxisVar+1)%2
        self.spinWaveAxisLine.visible = self.toggleAxisVar


                
##    def resetVisuals(self):
##        for x in range(self.nSpinsX):
##            for y in range(self.nSpinsY):
##                self.visualArray[x][y].tracer.visible = 0
##                self.visualArray[x][y].point.visible = 0
##                self.visualArray[x][y].vector.visible = 0

        

     
    def getArray(self):                         # handy, since we dont want to have to know the name of the object's actual variable!
        return self.visualArray





























