from visual import *


class VisualTracer:
    def __init__(self, length):
        self.length = length
        self.curve = curve(color=color.black)
        self.tvTracers = 1
        
    def step(self, updatePosition, updateColor):     
        if len(self.curve.pos) >= self.length + 64:
            newpos = self.curve.pos[64:]
            newcolor = self.curve.color[64:]
            
            self.curve.pos = newpos
            self.curve.color = newcolor

        self.curve.append(pos=updatePosition, color=updateColor)

    def delTracer(self):
        points = [[0.0,0.0,0.0]]*self.length
        self.curve.pos = points
        
    def getTracer(self):
        return self.points

    def toggleVisibility(self):
        self.tvTracers = (self.tvTracers+1)%2
        self.curve.visible = self.tvTracers
