#define BASE_FREQ 19800620

#define POT_CS 5
#define POT_SCK 6
#define POT_SI 7

#define DDS_CLOCK 8
#define DDS_LOAD 9
#define DDS_DATA 10
#define DDS_RESET 11

#define ANALOG_REFE A7
#define ANALOG_AMPL A6
#define ANALOG_PHAS A5

int flag_1 = 1;
int flag_2 = 1;

float amp = 1024.0;
float phi = 1024.0;

float amp_a = 1024.0;
float phi_a = 1024.0;

float amp_b = 1024.0;
float phi_b = 1024.0;

float r = 1024.0;

float kr = 1024.0;
float kp = 1024.0;
float ka = 1024.0;

float kr_1 = 1024.0;
float kp_1 = 1024.0;
float ka_1 = 1024.0;

float kr_2 = 1024.0;
float kp_2 = 1024.0;
float ka_2 = 1024.0;

float kr_3 = 1024.0;
float kp_3 = 1024.0;
float ka_3 = 1024.0;

float tax_to_deficit = 0.0;
float deficit = 0.0;

float id = 0.860;
float th_a = .504;
float th_b = .129;

int var_numb_1 = 0;
int var_numb_2 = 0;

int pot = 1;

int ByteReceived = 1;

void setup() {
  Serial.begin(115200);

  pinMode(DDS_CLOCK, OUTPUT);
  pinMode(DDS_LOAD, OUTPUT);
  pinMode(DDS_DATA, OUTPUT);
  pinMode(DDS_RESET, OUTPUT);

  pinMode(POT_CS, OUTPUT);
  pinMode(POT_SCK, OUTPUT);
  pinMode(POT_SI, OUTPUT);

  analogReadResolution(12);

  digitalWrite(DDS_RESET, HIGH);
  digitalWrite(DDS_RESET, LOW);

  digitalWrite(DDS_CLOCK, HIGH);
  digitalWrite(DDS_CLOCK, LOW);

  digitalWrite(DDS_LOAD, HIGH);
  digitalWrite(DDS_LOAD, LOW);
}

void loop() {
  ByteReceived = Serial.read();
  if (ByteReceived == '1') {
    flag_1 = 1;
  }
  if (flag_1 == 1) {
    for (int j = 1; j < 2; j += 1) {
      deficit = 196.0*196.0;
      var_numb_1 += j;

      for (int k = 1; k < 196; k += 1) {
        tax_to_deficit = float(sqrt(2.292256+deficit/(2.292256+k*k)));

        //Serial.println(k);
        //Serial.println(tax_to_deficit);

        if(4096.0-id <= .00982)
        {
          flag_2 = 1;
        }
        else
        {
          flag_2 = 0;
        }
        if (flag_2 == 1) {
          for (int l = 1; l < 2; l += 1) 
          {
            var_numb_2 += l;

            sendFrequency((float)(BASE_FREQ*(2.0*k/196.0-2.1635*k*(1.0/196.0-tax_to_deficit/196.0)*tax_to_deficit/deficit)));
            sendPotentiometer((float)(250.0+4096.0*(0.431085*k/196.0-k/196.0*3.1635*tax_to_deficit*tax_to_deficit/deficit)));

            read_input();
            amp_a = amp;
            phi_a = phi;

            //Serial.println((int)amp_a);
            //Serial.println((int)phi_a);
            delayMicroseconds(8);
            Serial.println("Pass - 0");
          }
        }
        if (flag_2 == 0) {
          for (int l = 1; l < 2; l += 1) 
          {
            var_numb_2 += l;

            sendFrequency((float)(BASE_FREQ*(2.0*k/196.0-2.1635*(k/196.0-tax_to_deficit)*tax_to_deficit/deficit)));
            sendPotentiometer((float)(256.0+4096.0*(0.431085*k/196.0-1.8365*(k/196.0-1.8635)*tax_to_deficit*tax_to_deficit/deficit)));

            read_input();
            amp_b = amp;
            phi_b = phi;

            //Serial.println((int)amp_b);
            //Serial.println((int)phi_b);
            delayMicroseconds(8);
            Serial.println("Fail - 1/0");
          }
        }
        id = 2048.0-(2048.0*(2.0+(float)amp_a*cos(3.1415926*phi_a/4096.0+th_a)+(float)amp_b*sin(3.1415926*phi_b/4096.0-th_b))/(2.0-(float)amp_a*cos(3.1415926*phi_a/4096.0+th_a)-(float)amp_b*sin(3.1415926*phi_b/4096.0-th_b)));

        //Serial.println((float)(BASE_FREQ*(2.0*k/196.0-2.8635*(k/196.0-tax_to_deficit)*tax_to_deficit/deficit)));
        //Serial.println((float)(512.0+8192.0*(0.431085*k/196.0-2.8365*(k/196.0-1.8635)*tax_to_deficit*tax_to_deficit/deficit)));

        //Serial.println(id);
      }
      delayMicroseconds(14);
      var_numb_2 = 0;
      flag_2 = 0;
    }
  }
  var_numb_1 = 0;
  flag_1 = 1;
}

void read_input() {
  kr_1 = (float)(analogRead(ANALOG_REFE));
  ka_1 = (float)(analogRead(ANALOG_AMPL));
  kp_1 = (float)(analogRead(ANALOG_PHAS));
  delayMicroseconds(2);

  kr_2 = (float)(analogRead(ANALOG_REFE));
  ka_2 = (float)(analogRead(ANALOG_AMPL));
  kp_2 = (float)(analogRead(ANALOG_PHAS));
  delayMicroseconds(2);

  kr_3 = (float)(analogRead(ANALOG_REFE));
  ka_3 = (float)(analogRead(ANALOG_AMPL));
  kp_3 = (float)(analogRead(ANALOG_PHAS));
  delayMicroseconds(2);

  ka = (float)(4096.0*(0.16*ka_1/kr_1+0.66*ka_2/kr_2+0.16*ka_3/kr_3));

  r = (float)(analogRead(ANALOG_REFE));

  amp = (int)((float)4096.0*ka/r);
  
  kr_1 = (float)(analogRead(ANALOG_REFE));
  ka_1 = (float)(analogRead(ANALOG_AMPL));
  kp_1 = (float)(analogRead(ANALOG_PHAS));
  delayMicroseconds(2);

  kr_2 = (float)(analogRead(ANALOG_REFE));
  ka_2 = (float)(analogRead(ANALOG_AMPL));
  kp_2 = (float)(analogRead(ANALOG_PHAS));
  delayMicroseconds(2);

  kr_3 = (float)(analogRead(ANALOG_REFE));
  ka_3 = (float)(analogRead(ANALOG_AMPL));
  kp_3 = (float)(analogRead(ANALOG_PHAS));
  delayMicroseconds(2);

  kp = (float)(4096.0*(0.16*kp_1/kr_1+0.66*kp_2/kr_2+0.16*kp_3/kr_3));

  r = (float)(analogRead(ANALOG_REFE));

  phi = (int)((float)4096.0*kp/r);
}

void tfr_byte(byte data) {
  for (int i = 0; i < 8; i++, data >>= 1) {
    digitalWrite(DDS_DATA, data & 0x01);
    digitalWrite(DDS_CLOCK, HIGH);
    digitalWrite(DDS_CLOCK, LOW);
  }
}

void pot_byte(byte data) {
  for (int i = 0; i < 8; i++, data >>= 1) {
    digitalWrite(POT_SI, data & 0x01);
    digitalWrite(POT_SCK, HIGH);
    digitalWrite(POT_SCK, LOW);
  }
}

void sendFrequency(double frequency) {
  digitalWrite(DDS_LOAD, LOW);
  int32_t freq = frequency * 4294967295 / 125000000;  // 125 MHz clock on 9850
  for (int b = 0; b < 4; b++, freq >>= 8) {
    tfr_byte(freq & 0xFF);
  }
  tfr_byte(0x000);
  digitalWrite(DDS_LOAD, HIGH);
  digitalWrite(DDS_LOAD, LOW);
}

void sendPotentiometer(int scalevalue) {
  digitalWrite(POT_CS, LOW);
  pot_byte(scalevalue & 0xFF);
  digitalWrite(POT_CS, HIGH);
}