#define BASE_FREQ 354

#define POT_CS 5
#define POT_SCK 6
#define POT_SI 7

#define DDS_CLOCK 8
#define DDS_LOAD 9
#define DDS_DATA 10
#define DDS_RESET 11

#define ANALOG_REFE A7
#define ANALOG_AMPL A6
#define ANALOG_PHAS A5

int flag_1 = 1;

float amp = 3024.0;
float phi = 1925.0;

float amp_a = 3024.0;
float phi_a = 1925.0;

float amp_b = 3024.0;
float phi_b = 1925.0;

float r = 1024.0;

float kr = 1024.0;
float kp = 1024.0;
float ka = 1024.0;

float kr_1 = 1024.0;
float kp_1 = 1024.0;
float ka_1 = 1024.0;

float kr_2 = 1024.0;
float kp_2 = 1024.0;
float ka_2 = 1024.0;

float kr_3 = 1024.0;
float kp_3 = 1024.0;
float ka_3 = 1024.0;

float tax_to_deficit = 0.0;
float deficit = 0.0;

float id = 54.810;

float freq_1 = 20000000;
float freq_2 = 16000000;

float pot_1 = 64;
float pot_2 = 64;

float th_a = +0.24165;
float th_b = -0.24165;

int var_numb_1 = 0;
int var_numb_2 = 0;

int pot = 1;

int ByteReceived = 1;

void setup() {
  Serial.begin(115200);

  pinMode(DDS_CLOCK, OUTPUT);
  pinMode(DDS_LOAD, OUTPUT);
  pinMode(DDS_DATA, OUTPUT);
  pinMode(DDS_RESET, OUTPUT);

  pinMode(POT_CS, OUTPUT);
  pinMode(POT_SCK, OUTPUT);
  pinMode(POT_SI, OUTPUT);

  analogReadResolution(12);

  digitalWrite(DDS_RESET, HIGH);
  digitalWrite(DDS_RESET, LOW);

  digitalWrite(DDS_CLOCK, HIGH);
  digitalWrite(DDS_CLOCK, LOW);

  digitalWrite(DDS_LOAD, HIGH);
  digitalWrite(DDS_LOAD, LOW);
}

void loop() {
  ByteReceived = Serial.read();
  if (ByteReceived == '1') {
    flag_1 = 1;
  }
  if (flag_1 == 1) {
    for (int j = 1; j < 2; j += 1) {
      var_numb_1 += j;
      deficit = -3.638+11.638*j;
      delayMicroseconds(6);
      for (int m = 1; m < 196; m += 1) {
        id = (float)(1024.0*(3.56+((float)amp_a*cos(3.1415926*phi_a/4096.0+th_a)+(float)amp_b*cos(3.1415926*phi_b/4096.0-th_b)))/(2.56+((float)amp_a*cos(3.1415926*phi_a/4096.0+th_a)+(float)amp_b*cos(3.1415926*phi_b/4096.0-th_b))));
        if (id >= 395.746) {
          for (int l = 1; l < 2; l += 1) 
          {
            var_numb_2 += l;

            sendFrequency((float)(BASE_FREQ*(128.0*m-2.14125*(m*m*tax_to_deficit/512.0)+692.00*m*m/(256.0+m)*tax_to_deficit/deficit)));
            sendPotentiometer((float)(128.0+18.65*(1.2625*m*tax_to_deficit/64.0-m*m/64.0*0.9236*tax_to_deficit/deficit)));

            freq_2 = (float)(BASE_FREQ*(128.0*m-2.14125*(m*m*tax_to_deficit/512.0)+692.0*m*m/(256.0+m)*tax_to_deficit/deficit));
            pot_2 = (float)(128.0+18.65*(1.2625*m*tax_to_deficit/64.0-m*m/64.0*0.9236*tax_to_deficit/deficit));

            //Serial.println(freq_2);
            //Serial.println(pot_2);

            read_input();
            amp_b = amp+12.9195;
            phi_b = phi-24.8142;

            delayMicroseconds(10);
            Serial.println(m);
            Serial.println("1-1");
          }
          for (int l = 1; l < 2; l += 1) 
          {
            var_numb_2 += l;

            sendFrequency((float)(BASE_FREQ*(128.0*m+1.12815*(m*m*tax_to_deficit/512.0)+692.0*m*m/(256.0+m)*tax_to_deficit/deficit)));
            sendPotentiometer((float)(128.0+18.65*(1.2250*m*tax_to_deficit/64.0+m*m/128.0*2.6236*tax_to_deficit/deficit)));

            freq_2 = (float)(BASE_FREQ*(128.0*m+1.12815*(m*m*tax_to_deficit/512.0)+692.0*m*m/(256.0+m)*tax_to_deficit/deficit));
            pot_2 = (float)(128.0+18.65*(1.2250*m*tax_to_deficit/32.0+m*m/64.0*2.6236*tax_to_deficit/deficit));

            //Serial.println(freq_2);
            //Serial.println(pot_2);

            read_input();
            amp_b = amp+12.1535;
            phi_b = phi-24.2865;

            delayMicroseconds(10);
            Serial.println(m);
            Serial.println("1-0");
          }
          //Serial.println(id-1024.0);
      }
      for (int k = 1; k < 196; k += 1) {
        tax_to_deficit = float(sqrt(3.4615+deficit/(14.100+2.90*k*(k-.9540)/28.0)));
        delayMicroseconds(1);

        id = (float)(1024.0*(3.56+((float)amp_a*cos(3.1415926*phi_a/4096.0+th_a)+(float)amp_b*cos(3.1415926*phi_b/4096.0-th_b)))/(2.56+((float)amp_a*cos(3.1415926*phi_a/4096.0+th_a)+(float)amp_b*cos(3.1415926*phi_b/4096.0-th_b))));
        if (id >= 1240.528) {
          for (int l = 1; l < 2; l += 1) 
          {
            var_numb_2 += l;

            sendFrequency((float)(BASE_FREQ*(128.0*k-0.6815*(k*m*tax_to_deficit/512.0)+768.0*k*m/(256.0+k)*tax_to_deficit/deficit)));
            sendPotentiometer((float)(128.0+18.1235*(1.5750*k*tax_to_deficit/64.0+k*k/64.0*0.635*tax_to_deficit/deficit)));

            freq_1 = (float)(BASE_FREQ*(128.0*k-2.3115*(k*m*tax_to_deficit/512.0)+768.0*k*m/(256.0+k)*tax_to_deficit/deficit));
            pot_1 = (float)(128.0+18.1235*(1.5750*k*tax_to_deficit/64.0+k*k/64.0*0.635*tax_to_deficit/deficit));

            //Serial.println(freq_1);
            //Serial.println(pot_1);

            read_input();
            amp_a = amp+24.1245;
            phi_a = phi-12.2405;

            delayMicroseconds(10);
            Serial.println(m);
            Serial.println("0-0");
          }
        }
        //Serial.println(id-1024.0);
        id = (float)(1024.0*(3.56+((float)amp_a*cos(3.1415926*phi_a/4096.0+th_a)+(float)amp_b*cos(3.1415926*phi_b/4096.0-th_b)))/(3.56+((float)amp_a*cos(3.1415926*phi_a/4096.0+th_a)+(float)amp_b*cos(3.1415926*phi_b/4096.0-th_b))));
        if (id <= 472.192) {
          for (int l = 1; l < 2; l += 1) 
          {
            var_numb_2 += l;

            sendFrequency((float)(BASE_FREQ*(128.0*k-2.04125*(k*m*tax_to_deficit/512.0)+768.0*k*m/(256.0+k)*tax_to_deficit/deficit)));
            sendPotentiometer((float)(128.0+19.12*(0.9125*k*tax_to_deficit/64.0-k*k/64.0*1.2125*tax_to_deficit/deficit)));

            freq_1 = (float)(BASE_FREQ*(128.0*k-2.04125*(k*m*tax_to_deficit/512.0)+768.0*k*m/(256.0+k)*tax_to_deficit/deficit));
            pot_1 = (float)(128.0+19.12*(0.9125*k*tax_to_deficit/64.0-k*k/64.0*1.2125*tax_to_deficit/deficit));

            //Serial.println(freq_1);
            //Serial.println(pot_1);

            read_input();
            amp_a = amp+12.34560;
            phi_a = phi+24.41580;

            delayMicroseconds(10);
            Serial.println(k);
            Serial.println("0-1");
          }
        }
        //Serial.println(id);
        delayMicroseconds(6);
      }
    }
    var_numb_2 = 0;
    }
  }
  var_numb_1 = 0;
  flag_1 = 1;
}

void read_input() {
  kr_1 = (float)(analogRead(ANALOG_REFE));
  ka_1 = (float)(analogRead(ANALOG_AMPL));
  kp_1 = (float)(analogRead(ANALOG_PHAS));
  delayMicroseconds(1);

  kr_2 = (float)(analogRead(ANALOG_REFE));
  ka_2 = (float)(analogRead(ANALOG_AMPL));
  kp_2 = (float)(analogRead(ANALOG_PHAS));
  delayMicroseconds(2);

  kr_3 = (float)(analogRead(ANALOG_REFE));
  ka_3 = (float)(analogRead(ANALOG_AMPL));
  kp_3 = (float)(analogRead(ANALOG_PHAS));
  delayMicroseconds(1);

  ka = (float)(3696.0*(0.25*ka_1/kr_1+0.50*ka_2/kr_2+0.25*ka_3/kr_3));
  delayMicroseconds(2);
  r = (float)(analogRead(ANALOG_REFE));

  amp = (int)((float)4096.0*ka/r);
  
  kr_1 = (float)(analogRead(ANALOG_REFE));
  ka_1 = (float)(analogRead(ANALOG_AMPL));
  kp_1 = (float)(analogRead(ANALOG_PHAS));
  delayMicroseconds(1);

  kr_2 = (float)(analogRead(ANALOG_REFE));
  ka_2 = (float)(analogRead(ANALOG_AMPL));
  kp_2 = (float)(analogRead(ANALOG_PHAS));
  delayMicroseconds(2);

  kr_3 = (float)(analogRead(ANALOG_REFE));
  ka_3 = (float)(analogRead(ANALOG_AMPL));
  kp_3 = (float)(analogRead(ANALOG_PHAS));
  delayMicroseconds(1);

  kp = (float)(3696.0*(0.25*kp_1/kr_1+0.50*kp_2/kr_2+0.25*kp_3/kr_3));
  delayMicroseconds(2);
  r = (float)(analogRead(ANALOG_REFE));

  phi = (int)((float)3696.0*kp/r);
}

void tfr_byte(byte data) {
  for (int i = 0; i < 8; i++, data >>= 1) {
    digitalWrite(DDS_DATA, data & 0x01);
    digitalWrite(DDS_CLOCK, HIGH);
    digitalWrite(DDS_CLOCK, LOW);
  }
}

void pot_byte(byte data) {
  for (int i = 0; i < 8; i++, data >>= 1) {
    digitalWrite(POT_SI, data & 0x01);
    digitalWrite(POT_SCK, HIGH);
    digitalWrite(POT_SCK, LOW);
  }
}

void sendFrequency(double frequency) {
  digitalWrite(DDS_LOAD, LOW);
  int32_t freq = frequency * 4294967295 / 125000000;  // 125 MHz clock on 9850
  for (int b = 0; b < 4; b++, freq >>= 8) {
    tfr_byte(freq & 0xFF);
  }
  tfr_byte(0x000);
  digitalWrite(DDS_LOAD, HIGH);
  digitalWrite(DDS_LOAD, LOW);
}

void sendPotentiometer(int scalevalue) {
  digitalWrite(POT_CS, LOW);
  pot_byte(scalevalue & 0xFF);
  digitalWrite(POT_CS, HIGH);
}