function w = FMP(image,basefreq)
p = imread(image);
pn = abs(p-256); //make white = zero
[r,c] = size(pn);
w = [];
t = soundsec(1/40,44100);
for i = 1:c;
  rw = zeros(t);
  mark = [];
  //find markings
  for j = 1:r;
     if pn(j,i) ~= 0;
     mark = [mark;j,i]
     end
  end
  [rm,cm] = size(mark);
  if length(w) ~= 0; //to simplify first column calculation
    //find the phase shift to match previous endpoint
    tp = [0,1/44100];
    phasem = [];
    for k = 0:(1/100):(2*%pi);
      rwp = [0,0];
      for h = 1:rm;
         rwp = rwp + ((pn(mark(h,1),i)/2560) * sin(tp*2*%pi*27.5*2^((r-mark(h,1)+basefreq)/40) + k));
      end
      // phase matrix [phase, position diff, slope diff]
      phasem = [phasem;k,abs((w(1,$)-rwp(1,1))),abs((w(1,$-1)-w(1,$))-(rwp(1,1)-rwp(1,2)))];
    end
    [m,rk] = min(phasem(:,2) + phasem(:,3));
    //calculate the column data with that phase
    for h = 1:rm;
       rw = rw + ((pn(mark(h,1),i)/2560) * sin(t*2*%pi*27.5*2^((r-mark(h,1)+basefreq)/40) + phasem(rk,1)));
    end
  else
    for h = 1:rm;
       rw = rw + ((pn(mark(h,1),i)/2560) * sin(t*2*%pi*27.5*((r-mark(h,1)+basefreq)/40)));
    end
  end
  w = [w,rw];
end
endfunction
