float BASE_FREQ = 15100430;

float amp = 3976.0;
float phi = 1140.0;

float amp_a = 3096.0;
float phi_a = 1992.0;

float amp_b = 3096.0;
float phi_b = 1992.0;

float pi = 3.14159265358979323846264338;

float kr = 1024.0;
float kp = 1024.0;
float ka = 1024.0;

float kr_1 = 1024.0;
float kp_1 = 1024.0;
float ka_1 = 1024.0;

float kr_2 = 1024.0;
float kp_2 = 1024.0;
float ka_2 = 1024.0;

float kr_3 = 1024.0;
float kp_3 = 1024.0;
float ka_3 = 1024.0;

float tax_to_deficit = 0.5241*log((4.0*pi)/sqrt(300.0));
float deficit = 3.1296*log(sqrt(184.0)/(2.0*pi));

float y = 15.485;
float yd = 7.126;

float beta = 1.56;

int var_numb_1 = 1.2459;
int var_numb_2 = 2.8752;

int freq_1 = 13895060;
int freq_2 = 8456405;

int pote_1 = 2410;
int pote_2 = 3856;

int flag_0 = 0;
int flag_1 = 1;
int flag_2 = 1;

int j_flag = 1;
int flag_goal_previous = 1;

int addend = 996;
int ded = 1;
int j = 2;

int ByteReceived = 0;
int nulled = 1;

byte nosaid_buffer = 1;
byte said = 1;

String instruction_base = "";

int j_lim = 0;
int k_lim = 0;
int m_lim = 0;

void setup() {
  Serial.begin(921600);
  analogRead(12);

  pinMode(PC_8, INPUT);
  pinMode(PC_6, INPUT);

  pinMode(PA_9, OUTPUT);
  pinMode(PA_9, OUTPUT);
}

void loop() {
  delayMicroseconds(2);
  
  ByteReceived = Serial.read();

  if (ByteReceived == '1') {
    flag_0 = 1;
    flag_goal_previous = 1;
    nulled = 1;
  }

  if (addend <= j and flag_0 and flag_goal_previous and nulled) {
    nulled = 1;
  } else {
    nulled = 0;
  }

  if (flag_0 and flag_goal_previous) {
    j_lim = Serial.parseInt();
    k_lim = Serial.parseInt();
    m_lim = Serial.parseInt();
    
    instruction_base = Serial.readString();
    instruction_base.trim();
    byte nosaid_buffer[(int)instruction_base.length()+1];
          
    for (int l = 0; l < (int)sizeof(nosaid_buffer); l++) {
      j += (int)(j_flag%2+j_lim%2+k_lim%2+m_lim%2)%((int)nosaid_buffer[l]);

      for (int o = 0; o <= j_lim; o += 1) { 
        for (int k = 0; k <= k_lim; k += 1) {       
          for (int m = 0; m <= m_lim; m += 1) {
              instruction_base.getBytes(nosaid_buffer, sizeof(nosaid_buffer));
              delayMicroseconds(2);

              taxes(var_numb_1, var_numb_2, tax_to_deficit, deficit, j, k, m);
              principles(j, k, m, var_numb_1, var_numb_2, tax_to_deficit);
          
              y = (float)((4096.0-(amp_a)*cos(pi*(phi_a-phi_b)/4096.0)+(amp_b)*cos(pi*(phi_a-phi_b)/4096.0))/(2048.0-(amp_a-amp_b)*(amp_a+amp_b)/2048.0*sin(2.0*pi*(phi_a+phi_b)/4096.0)*cos(2.0*pi*(phi_a+phi_b)/4096.0)));
              yd = (float)(32.0*(1-(m*k*var_numb_1*var_numb_2)*(k*(1-m*var_numb_1/var_numb_2))/((j_flag-j)/(k*m)+1)));
              beta = (float)(4.0*yd-(var_numb_1*y+var_numb_2*y)*yd);

              if (5056.28 >= y) {
                for (int l = 0; l <= 2; l += 1) 
                {
                  taxes(var_numb_1, var_numb_2, tax_to_deficit, deficit, j, k, m);
                  principles(j, k, m, var_numb_1, var_numb_2, tax_to_deficit);
                  
                  y = (float)((4096.0-(amp_a)*cos(pi*(phi_a-phi_b)/4096.0)+(amp_b)*cos(pi*(phi_a-phi_b)/4096.0))/(2048.0-(amp_a-amp_b)*(amp_a+amp_b)/2048.0*sin(2.0*pi*(phi_a+phi_b)/4096.0)*cos(2.0*pi*(phi_a+phi_b)/4096.0)));
                  yd = (float)(32.0*(1-(m*k*var_numb_1*var_numb_2)*(k*(1-m*var_numb_1/var_numb_2))/((j_flag-j)/(k*m)+1)));
                  beta = (float)(4.0*yd-(var_numb_1*y+var_numb_2*y)*yd);

                  if (5289.23 >= y+beta*yd) {
                    flag_1 = 1;
                    flag_2 = 0;

                    k += 1+(j-m*flag_1+k*flag_2)%2;
                    m += 1+(j+m*flag_1-k*flag_2)%2;
                    
                    flags(j_flag, j, flag_1, flag_2, addend, ded);

                    if (j_flag%2 and flag_goal_previous) {
                      Serial.println("t = -0.10 mark");
                      
                      flag_goal_previous = 1;
                      j += (flag_1-flag_2)%2;           
                    }
                  }

                  taxes(var_numb_1, var_numb_2, tax_to_deficit, deficit, j, k, m);
                  principles(j, k, m, var_numb_1, var_numb_2, tax_to_deficit);

                  y = (float)((4096.0-(amp_a)*cos(pi*(phi_a-phi_b)/4096.0)+(amp_b)*cos(pi*(phi_a-phi_b)/4096.0))/(2048.0-(amp_a-amp_b)*(amp_a+amp_b)/2048.0*sin(2.0*pi*(phi_a+phi_b)/4096.0)*cos(2.0*pi*(phi_a+phi_b)/4096.0)));
                  yd = (float)(32.0*(1-(m*k*var_numb_1*var_numb_2)*(k*(1-m*var_numb_1/var_numb_2))/((j_flag-j)/(k*m)+1)));
                  beta = (float)(4.0*yd-(var_numb_1*y+var_numb_2*y)*yd);

                  if (3974.1 <= y-beta*yd) {
                    flag_1 = 1;
                    flag_2 = 1;
    
                    k += 1+(j+m*flag_1+k*flag_2)%2;
                    m += 1+(j+m*flag_1-k*flag_2)%2;

                    flags(j_flag, j, flag_1, flag_2, addend, ded);

                    if (j_flag%2 and flag_goal_previous) {
                      Serial.println("t = -0.11 mark");
                   
                      flag_goal_previous = 1;
                      j += (flag_1-flag_2)%2;              
                    }
                  }
                  
                  delayMicroseconds(3);
                }
              }

              delayMicroseconds(2);

              taxes(var_numb_1, var_numb_2, tax_to_deficit, deficit, j, k, m);
              principles(j, k, m, var_numb_1, var_numb_2, tax_to_deficit);

              y = (float)((4096.0-(amp_a)*cos(pi*(phi_a-phi_b)/4096.0)+(amp_b)*cos(pi*(phi_a-phi_b)/4096.0))/(2048.0-(amp_a-amp_b)*(amp_a+amp_b)/2048.0*sin(2.0*pi*(phi_a+phi_b)/4096.0)*cos(2.0*pi*(phi_a+phi_b)/4096.0)));
              yd = (float)(32.0*(1-(m*k*var_numb_1*var_numb_2)*(k*(1-m*var_numb_1/var_numb_2))/((j_flag-j)/(k*m)+1)));
              beta = (float)(4.0*yd-(var_numb_1*y+var_numb_2*y)*yd);

              if (5658.4 <= y) {
                for (int l = 0; l < 2; l += 1) 
                {
                  taxes(var_numb_1, var_numb_2, tax_to_deficit, deficit, j, k, m);
                  principles(j, k, m, var_numb_1, var_numb_2, tax_to_deficit);

                  y = (float)((4096.0-(amp_a)*cos(pi*(phi_a-phi_b)/4096.0)+(amp_b)*cos(pi*(phi_a-phi_b)/4096.0))/(2048.0-(amp_a-amp_b)*(amp_a+amp_b)/2048.0*sin(2.0*pi*(phi_a+phi_b)/4096.0)*cos(2.0*pi*(phi_a+phi_b)/4096.0)));
                  yd = (float)(32.0*(1-(m*k*var_numb_1*var_numb_2)*(k*(1-m*var_numb_1/var_numb_2))/((j_flag-j)/(k*m)+1)));
                  beta = (float)(4.0*yd-(var_numb_1*y+var_numb_2*y)*yd);

                  if (4871.2 >= y+beta*yd) {
                    flag_1 = 0;
                    flag_2 = 1;
    
                    k += 1+(j-m*flag_1+k*flag_2)%2;
                    m += 1+(-j+m*flag_1+k*flag_2)%2;

                    flags(j_flag, j, flag_1, flag_2, addend, ded);
    
                    if (j_flag%2 and flag_goal_previous) {
                      Serial.println("t = -0.01 mark");
    
                      flag_goal_previous = 1;
                      j += (flag_1-flag_2)%2;         
                    }
                  }

                  taxes(var_numb_1, var_numb_2, tax_to_deficit, deficit, j, k, m);
                  principles(j, k, m, var_numb_1, var_numb_2, tax_to_deficit);
                  
                  y = (float)((4096.0-(amp_a)*cos(pi*(phi_a-phi_b)/4096.0)+(amp_b)*cos(pi*(phi_a-phi_b)/4096.0))/(2048.0-(amp_a-amp_b)*(amp_a+amp_b)/2048.0*sin(2.0*pi*(phi_a+phi_b)/4096.0)*cos(2.0*pi*(phi_a+phi_b)/4096.0)));
                  yd = (float)(32.0*(1-(m*k*var_numb_1*var_numb_2)*(k*(1-m*var_numb_1/var_numb_2))/((j_flag-j)/(k*m)+1)));
                  beta = (float)(4.0*yd-(var_numb_1*y+var_numb_2*y)*yd);

                  if (4424.5 <= y-beta*yd) {
                    flag_1 = 0;
                    flag_2 = 0;
    
                    k += 1+(j-m*flag_1+k*flag_2)%2;
                    m += 1+(j+m*flag_1-k*flag_2)%2;
          
                    flags(j_flag, j, flag_1, flag_2, addend, ded);

                    if (j_flag%2 and flag_goal_previous) {
                      Serial.println("t = -0.00 mark");
                                        
                      flag_goal_previous = 1;
                      j += (flag_1-flag_2)%2;         
                    }
                  }

                  delayMicroseconds(3);
                }
              }
            }
          }
        }
      }
    }
    
  if (flag_0 != 0 and addend <= j) {
    flag_0 = 1;
    flag_goal_previous = 1;
    nulled = 0;
    Serial.println("Closed Channel.");
  } else {
    flag_0 = 1;
    flag_goal_previous = 1;
    nulled = 1;
  }

  j += j_flag%(ded-addend+j)-1;
  j_flag += (j_flag+j%2)%ded+1;

  ByteReceived = Serial.read();

  if (ByteReceived == '1') {
    flag_0 = 1;
    flag_goal_previous = 1;
    nulled = 1;
  }
}

void read_input() {
  sendFrequency(freq_1, nosaid_buffer);
  sendPotentiometer(pote_1, freq_1);
  
  ka_1 = (float)(analogRead(PA_8));
  kp_1 = (float)(analogRead(PA_8));
  
  ka_2 = (float)(analogRead(PA_8));
  kp_2 = (float)(analogRead(PA_8));

  ka_3 = (float)(analogRead(PA_8));
  kp_3 = (float)(analogRead(PA_8));

  ka = (float)(1.618*ka_1+2.618*ka_2*(y*yd)+1.0*ka_3*(beta*y));
  
  amp_a = (int)(ka);

  kp = (float)(-.333*kp_1+2.0*kp_2*beta+0.5*kp_3*y*yd);

  phi_a = (int)(kp);

  sendFrequency(freq_2, nosaid_buffer);
  sendPotentiometer(pote_2, freq_2);
  
  ka_1 = (float)(analogRead(PA_6));
  kp_1 = (float)(analogRead(PA_6));
  
  ka_2 = (float)(analogRead(PA_6));
  kp_2 = (float)(analogRead(PA_6));
  
  ka_3 = (float)(analogRead(PA_6));
  kp_3 = (float)(analogRead(PA_6));

  ka = (float)(1.618*ka_1+2.618*ka_2*(y*yd)+1.0*ka_3*(beta*y));
  
  amp_a = (int)(ka);

  kp = (float)(-.333*kp_1+2.0*kp_2*beta+0.5*kp_3*y*yd);

  phi_a = (int)(kp);
}

void set_sag(int j, int k, int m) {
  if ((k+1)%2 and (m-1)%2) {
    j += (j+(j*(k+1))%2+1)%2;
    delayMicroseconds(1);
  } else {
    j += j+(j*(k-1))%2-1;
    k += (j+k-1)%2+(m+1)%2;
    delayMicroseconds(1);
  }

  ByteReceived = Serial.read();

  if (ByteReceived == '1' and (addend-ded+j)%2) {
    flag_0 = 1;
    flag_goal_previous = 1;
    nulled = 1;
    addend += 1-(ded+j_flag)%2+(addend-j)%2;
    ded += -((1+(ded-j_flag)%2)%(addend+j))%2;
  } else {
    j += (ded-addend+j_flag)%2;
  }

  if (addend >= j and flag_0) {
    flag_0 = 1;
    flag_goal_previous = 1;
    j += ((k+j+j_flag)+(addend+ded)%2)%2;
  }
}

void principles(int j, int k, int m, int var_numb_1, int var_numb_2, int tax_to_deficit) {
    set_sag(j,k,m);

    freq_1 = (float)(24.0*(k/2.00+(4.0*(2.0/(sqrt(5.0)+1.00))*(m*log(18.0))+sqrt(3.0)*k/(var_numb_1+k%m+1.0)*tax_to_deficit*log(8.0)))/16.0);
    pote_1 = (float)((24.0*pi*2.0*ded+512.0*(sqrt(3.0)*k/2.0*deficit*var_numb_1+(pi/2.0)*(m/2.0)*log(24.0)-k*(sqrt(5.0)-1.00)*var_numb_2*tax_to_deficit)*log(var_numb_1))/((var_numb_2*(k%m)+(addend+ded+j%m)%2))/32.0);

    freq_2 = (float)(24.0*(k/2.00+(4.0*(2.0/(sqrt(5.0)-1.00))*(m*log(18.0))+sqrt(3.0)*k/(var_numb_1+j%m+4.0)*tax_to_deficit*log(8.0)))/16.0);
    pote_2 = (float)((24.0*pi*2.0*ded+512.0*(sqrt(3.0)*k/2.0*deficit*var_numb_1+(pi/2.0)*(m/2.0)*log(24.0)-k*(sqrt(5.0)+1.00)*var_numb_2*tax_to_deficit)*log(var_numb_2))/((var_numb_2*(k%m)+(addend+ded+j%m)%2))/32.0);

    read_input();
}

void flags(int j_flag, int j, int flag_1, int flag_2, int addend, int ded) {
    j_flag += (j+1)%2-(flag_1+flag_2)%2;
    
    if (j_flag%2) {
      j += 1;
      j_flag += (j)%2+(flag_1-flag_2)%2;
    }

    ded += -((j_flag+addend-j)%(j_flag-j-ded))%2;
    j_flag += j_flag+(addend-ded)%2;
}

void taxes(float var_numb_1, float var_numb_2, float tax_to_deficit, float deficit, int j, int k, int m) {
    tax_to_deficit = (float)(((192.0/18.0)*(j+k)*m*var_numb_1*deficit+(192.0/18.0)*(j+m)*k*var_numb_2)/(m*log(192.0/120.0)*var_numb_1*deficit*+(k+m)*var_numb_2*deficit)/4096.0);

    var_numb_1 = (float)((k*(k-1))*((k+1)%(addend-j)))/(log(119.0));
    var_numb_2 = (float)((k*(1+k))*((k-1)%(addend+j)))/(log(126.0));
}

void tfr_byte(int32_t buffer, double frequency) {
    analogWrite(PC_8, (int)(buffer+(int32_t)((var_numb_1-var_numb_2)*y*yd)));
    analogWrite(PC_6, (int)(buffer));
}

void pot_byte(double frequency, double data) {
    analogWrite(PA_9, (int)data*yd-(int)(var_numb_1-var_numb_2)/(var_numb_2)*frequency*y*yd);
    analogWrite(PA_9, (int)data*yd+(int)(var_numb_1)/(var_numb_2)*frequency*yd);
    said = (int)(y*var_numb_2-yd*var_numb_1)*analogRead(PC_6);
}

void sendFrequency(double frequency, double buffer) {
  analogWrite(PC_8, (int)var_numb_1*frequency*y);
  analogWrite(PC_6, (int)var_numb_2*frequency*yd);
  tfr_byte(buffer, frequency);
}

void sendPotentiometer(int scalevalue, double frequency) {
  said = (int)analogRead(PC_8);
  analogWrite(PA_9, ((int)scalevalue*yd*y-(int)said*y));
}
